<?php
require_once 'header.php';
?>
<script src="js/chart.min.js"></script>
<script>
function draw(type="bar"){
  $('#chart').remove(); // this is my <canvas> element
  $('#chart-container').append('<canvas id="chart"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {from : $('#from').val(), to : $('#to').val(), kwd_sus:$('#pack').val(), megethos:$('#megethos').val(), type:'sizes'},
    success: function(r){
	     data = JSON.parse(r);
      //  console.log(data);
    }
  });

  var ctx = document.getElementById("chart");
  if(type=="bar"){
    var myChart = new Chart(ctx, {
      type: "bar",
      data: {
          labels: data["headers"],
          datasets: [
              {
                label: "Κανονικά",
                data: data["ar_psar"],
                backgroundColor: "#2bb721",
                stack: 1
              },
              {
                label: "Υπομεγέθη",
                data: data["upomege8h"],
                backgroundColor: "red",
                stack: 1
              },
              {
                label: "Υπερμεγέθη",
                data: data["upermege8h"],
                backgroundColor: "#007cc4",
                stack: 1
              }
          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:true
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
    });
  } else {
    var myChart = new Chart(ctx, {
      type: 'pie',
      data: {
          labels: [`Υπομεγέθη(${data['upomege8h'][0]})`,`Υπερμεγέθη(${data['upermege8h'][0]})`, `Κανονικά(${data['ar_psar'][0]})`],
          datasets: [
            {
              data: [data["upomege8h"][0],data["upermege8h"][0],data["ar_psar"][0]],
              backgroundColor: ['red', '#007cc4', '#2bb721'],
              stack: 1
            }
          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:false
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
    });
  }
}


function getPack(){
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {type:'pack'},
    success: function(r){
	     data = JSON.parse(r);
       data.forEach(function(item){
				 $("#pack").append("<option value='"+item[0]+"'>"+item[0]+"</option>");
			 });
     }
   });
}

$('document').ready(function(){
  draw();
  getPack();
  $('#from, #to, #pack, #megethos').on('change', function(){
    if($('#megethos').val()==''){
      draw();
    } else {
      draw('pie');
    }
  });
});
</script>
<div class="row">
  <div class="col-sm-2 col-sm-offset-2">
    Από: <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2">
    Έως: <input type="date" id="to" class="form-control" />
  </div>
  <div class="col-sm-2">
    Συσκευαστήριο:
    <select id="pack" class="form-control">
      <option value="" selected>Όλα</option>
    </select>
  </div>
  <div class="col-sm-2">
    Μέγεθος:
    <select class="form-control" id="megethos" name="megethos" data-order="'.$i.'">
			<option value="" selected>Όλα</option>
			<option>2/3</option>
			<option>3/4</option>
			<option>400/500</option>
			<option>300/500</option>
			<option>500/600</option>
			<option>500/1000</option>
			<option>4/6</option>
			<option>6/8</option>
			<option>8/1000</option>
			<option>1000+</option>
			<option>1500+</option>
			<option>Άλλο</option>
		</select>
  </div>
</div>
<br />
<div class="row">
  <div id="chart-container">
    <canvas id="chart"></canvas>
  </div>
</div>
<?php require('footer.php'); ?>