<?php
require_once('header.php');
?>
<script>
    function getData(){
        $.post({
            url: 'chartdat.php',
            data: {type: 'eikona', from : $('#from').val(), to : $('#to').val(), user: $('#user').val()},
            success: function(r){
                // console.log(r);
                r = JSON.parse(r);
                for(var key in r){
                    $(`#controls .${key}`).html((r[key]['controls']===null ? 0 : r[key]['controls']));
                    $(`#boxes .${key}`).html(r[key]['boxes']);
                    $(`#median-boxes .${key}`).html(r[key]['median']['boxes']);
                    $(`#median-controls .${key}`).html(r[key]['median']['controls']);
                    $(`#median-pictures .${key}`).html(r[key]['median']['pictures']);
                }
            }
        })
    }
    function getUsers(){
        $.post({
            url: 'chartdat.php',
            data: {type: 'users'},
            success: function(r){
                $("#user").html(`<option value="" selected>Όλα</option>${r}`);
            }
        });
    }

    $(document).ready(function(){
        getData();
        getUsers();
        $('#from, #to, #user').on('change', function(){
            getData();
        });
    });
</script>
<h3 class="text-center"><u>Συνολική Εικόνα</u></h3>
<center style="color:#909090;">(beta)</center>
<div class="row" style="margin-top:2rem;">
  <div class="col-sm-2 text-center col-sm-offset-3">
    Από: <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2 text-center">
    Έως: <input type="date" id="to" class="form-control" />
  </div>
  <div class="col-sm-2 text-center">
    Χρήστης:
    <select id="user" class="form-control">
      
    </select>
  </div>
</div>
<div class="row" style="margin-top:2rem;">
    <table class="table table-striped table-hover table-bordered text-center">
        <thead>
            <tr>
                <th class="col-sm-2"></th>
                <th class="text-center">Selonda</th>
                <th class="text-center">Selonda2</th>
                <th class="text-center">MedFrigo</th>
            </tr>
        </thead>
        <tbody>
            <tr id="controls">
                <td style="font-weight:600;">Έλεγχοι</td>
                <td class="selonda">0</td>
                <td class="selonda2">0</td>
                <td class="medfrigo">0</td>
            </tr>
            <tr id="boxes">
                <td style="font-weight:600;">Κιβώτια</td>
                <td class="selonda">0</td>
                <td class="selonda2">0</td>
                <td class="medfrigo">0</td>
            </tr>
            <?php //if($_SESSION['susername']=='admin'){ ?>
            <tr id="median-controls">
                <td style="font-weight:600;">Μεσος Όρος Ελέγχων ανα μέρα</td>
                <td class="selonda">0</td>
                <td class="selonda2">0</td>
                <td class="medfrigo">0</td>
            </tr>
            <tr id="median-boxes">
                <td style="font-weight:600;">Μεσος Όρος Κιβωτίων ανα μέρα</td>
                <td class="selonda">0</td>
                <td class="selonda2">0</td>
                <td class="medfrigo">0</td>
            </tr>
            <tr id="median-pictures">
                <td style="font-weight:600;">Μεσος Όρος Φωτογραφιών ανα μέρα</td>
                <td class="selonda">0</td>
                <td class="selonda2">0</td>
                <td class="medfrigo">0</td>
            </tr>
            <?php //} ?>
        </tbody>
    </table>
</div>
<?php require 'footer.php';
