<?php
require_once('header.php');
?>
<script src="js/chart.min.js"></script>
<script>
function draw(){
  $('#chart').remove(); // this is my <canvas> element
  $('#chart-container').append('<canvas id="chart"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {from : $('#from').val(), to : $('#to').val(), type:'ice'},
    success: function(r){
	     data = JSON.parse(r);
       console.log(data);
     }
   });

  var ctx = document.getElementById("chart");
  var myChart = new Chart(ctx, {
      type: 'bar',
      data: {
          labels: data["susk"],
          datasets: [
            {
              label: "60%-",
              data: data["red"],
              backgroundColor: "red",
              stack: 3
            },
            {
              label: "60%-80%",
              data: data["orange"],
              backgroundColor: "orange",
              stack: 2
            },
            {
              label: "80%+",
              data: data["green"],
              backgroundColor: "#3FBF3F",
              stack: 1
            }
            
          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:true
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
  });
}

function drawPie(kwd_susk=''){
  $('#chart').remove(); // this is my <canvas> element
  $('#chart-container').append('<canvas id="chart"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {kwd_sus: kwd_susk, from : $('#from').val(), to : $('#to').val(), type:'getPack'},
    success: function(r){
	     data = JSON.parse(r);
      //  console.log(data);
     }
   });
  var ctx = document.getElementById("chart");
  var myChart = new Chart(ctx, {
      type: 'pie',
      data: {
          labels: ["60%- ("+data["red"]+")","60%-80% ("+data["orange"]+")", "80%+ ("+data["green"]+")"],
          datasets: [
            {
              data: [data["red"],data["orange"],data["green"]],
              backgroundColor: ['red', 'orange', '#3FBF3F'],
              stack: 1
            }

          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:false
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
  });

}

function getPack(){
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {type:'pack'},
    success: function(r){
	     data = JSON.parse(r);
       data.forEach(function(item){
				 $("#pack").append("<option value='"+item[0]+"'>"+item[0]+"</option>");
			 });
     }
   });
}

$('document').ready(function(){
  draw();
  getPack();
  $('#from, #to').on('change', function(){
    if($('#pack').val()==""){
      draw();
    } else {
      drawPie($('#pack').val());
    }
  });
  $('#pack').on("change", function(){
    if($(this).val()!=''){
      drawPie($(this).val());
    } else {
      draw();
    }

  });
});
</script>
<div class="row">
  <div class="col-sm-2 col-sm-offset-3">
    Από: <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2">
    Έως: <input type="date" id="to" class="form-control" />
  </div>
  <div class="col-sm-2">
    Συσκευαστήριο:
    <select id="pack" class="form-control">
      <option value="" selected>Όλα</option>
    </select>
  </div>
</div>
<br />
<div class="row">
  <div id="chart-container">
    <canvas id="chart"></canvas>
  </div>
</div>
<?php require('footer.php'); ?>