<?php
include('header.php');
?>
<script src="js/chart.min.js"></script>
<script>
$(document).ready(function(){
  getPack();
  drawPie();
  $('#from, #to, #pack, #megethos, #varos').on('change', function(){
    drawPie();
  });
});

function getPack(){
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {type:'pack'},
    success: function(r){
	     data = JSON.parse(r);
       data.forEach(function(item){
				 $("#pack").append("<option value='"+item[0]+"'>"+item[0]+"</option>");
			 });
     }
   });
}

function makeTotals(totals){
  $.each(totals, function(key,value){
    e = $('#megethos option').filter(function () { return $(this).val() == key; });
    e.html(e.val()+` (${value})`);
  });
};

function drawPie(){
  $('#chart').remove(); // this is my <canvas> element
  $('#chart-container').append('<canvas id="chart"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {from:$('#from').val(), to:$('#to').val(), kwd_sus:$('#pack').val(), megethos:$('#megethos').val(), varos: $('#varos').val(), type:'e'},
    success: function(r){
       r = JSON.parse(r);
	     data = r['chartData'];
       totals = r['totals'];
       makeTotals(totals);
       
       $.each(data,function(key, value){
         $('#'+key).html(value);
       });
     }
   });
   //(x*100)/y
  var ctx = document.getElementById("chart");
  var myChart = new Chart(ctx, {
      type: 'pie',
      data: {
          labels: [
            "red("+((data['red']*100)/data['total']).toFixed(0)+"%)", 
            "orange("+((data['orange']*100)/data['total']).toFixed(0)+"%)", 
            "yellow("+((data['yellow']*100)/data['total']).toFixed(0)+"%)", 
            "green("+((data['green']*100)/data['total']).toFixed(0)+"%)", 
            "blue("+((data['blue']*100)/data['total']).toFixed(0)+"%)", 
            "blueblack("+((data['blueblack']*100)/data['total']).toFixed(0)+"%)"],
          datasets: [
            {
              data: [data['red'],data['orange'],data['yellow'],data['green'], data['blue'], data['blueblack']],
              backgroundColor: ["red", "orange", "yellow", "#00c71a", "#007cc4", "darkblue"],
              stack: 1
            }

          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:false
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
  });

}

</script>
<style>
  .red{
    background-color:red;
    color:#f4f4f4;
    padding:0 0.5rem 0 0.5rem;
  }
  .orange{
    background-color:orange;
    color:#040404;
    padding:0 0.5rem 0 0.5rem;
  }
  .yellow{
    background-color:yellow;
    color:#040404;
    padding:0 0.5rem 0 0.5rem;
  }
  .green{
    background-color:#00c71a;
    color:#040404;
    padding:0 0.5rem 0 0.5rem;
  }
  .blue{
    background-color:#007cc4;
    color:#f4f4f4;
    padding:0 0.5rem 0 0.5rem;
  }
  .blueblack{
    background-color:darkblue;
    color:#f4f4f4;
    padding:0 0.5rem 0 0.5rem;
  }
</style>
<div class="row" style="margin-bottom:2rem;">
  <div class="col-sm-2 col-sm-offset-1">
    Από: <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2">
    Έως: <input type="date" id="to" class="form-control" />
  </div>
  <div class="col-sm-2">
    Συσκευαστήριο:
    <select id="pack" class="form-control">
      <option value="" selected>Όλα</option>
    </select>
  </div>
  <div class="col-sm-2">
    Μέγεθος:
    <select class="form-control" id="megethos" name="megethos">
			<option value="" selected>Όλα</option>
			<option value="2/3">2/3</option>
			<option value="3/4">3/4</option>
			<option value="400/500">400/500</option>
			<option value="300/500">300/500</option>
			<option value="500/600">500/600</option>
			<option value="500/1000">500/1000</option>
			<option value="4/6">4/6</option>
			<option value="6/8">6/8</option>
			<option value="8/1000">8/1000</option>
			<option value="1000+">1000+</option>
			<option value="1500+">1500+</option>
			<option value="Άλλο">Άλλο</option>
		</select>
  </div>
  <div class="col-sm-2">
    Βάρος:
    <select name="varos" id="varos" class="form-control">
      <option value="">Όλα</option>
      <option value="3">3</option>
      <option value="6">6</option>
      <option value="10">10</option>
    </select>
  </div>
</div>

<div class="row">
  <div class="col-md-2" style="border:solid 1px darkgrey;padding:1rem;">
    Σύνολο Κιβωτίων: <span class="pull-right" id="total"></span><br/>
    Σκούρο Μπλέ: <span class="pull-right blueblack" id="blueblack"></span><br/>
    Μπλέ: <span class="pull-right blue" id="blue"></span><br/>
    Πράσινο: <span class="pull-right green" id="green"></span><br/>
    Κίτρινο: <span class="pull-right yellow" id="yellow"></span><br/>
    Πορτοκαλί: <span class="pull-right orange" id="orange"></span><br/>
    Κόκκινο: <span class="pull-right red" id="red"></span><br/>
    <br/><br/>
    <b>3 Kg</b><br/>
    Σκούρο Μπλέ:<span class="pull-right blueblack">++3050g</span><br />
    Μπλέ:<span class="pull-right blue">3030g - 3050g</span><br />
    Πράσινο:<span class="pull-right green">2995g - 3030g</span><br />
    Κίτρινο:<span class="pull-right yellow">2985g - 2995g</span><br />
    Πορτοκαλί:<span class="pull-right orange">2955g - 2985g</span><br />
    Κόκκινο:<span class="pull-right red">--2995g</span><br />
    <br/><br/>
    <b>6 Kg</b><br/>
    Σκούρο Μπλέ:<span class="pull-right blueblack">++6100g</span><br />
    Μπλέ:<span class="pull-right blue">6060g - 6100g</span><br />
    Πράσινο:<span class="pull-right green">5990g - 6060g</span><br />
    Κίτρινο:<span class="pull-right yellow">5970g - 5990g</span><br />
    Πορτοκαλί:<span class="pull-right orange">5910g - 5970g </span><br />
    Κόκκινο:<span class="pull-right red">--5910g</span><br />
    <br/><br/>
    <b>10 Kg</b><br/>
    Σκούρο Μπλέ:<span class="pull-right blueblack">++10167g</span><br />
    Μπλέ:<span class="pull-right blue">10100g - 10167g</span><br />
    Πράσινο:<span class="pull-right green">9983g - 10100g</span><br />
    Κίτρινο:<span class="pull-right yellow">9950g - 9983g</span><br />
    Πορτοκαλί:<span class="pull-right orange">9850g - 9950g</span><br />
    Κόκκινο:<span class="pull-right red">--9850g</span><br />
  </div>
  <div class="col-md-10">
    <div id="chart-container">
      <canvas id="chart"></canvas>
    </div>
  </div>

</div>
<?php require('footer.php'); ?>