<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta charset="utf-8">
<?php
ini_set('memory_limit', '256M');
// error_reporting(0);
require('connect.php');
include('header.php');
date_default_timezone_set("Europe/Athens");
class ResizeImage
{
  private $ext;
  private $image;
  private $newImage;
  private $origWidth;
  private $origHeight;
  private $resizeWidth;
  private $resizeHeight;

  /**
   * Class constructor requires to send through the image filename
   *
   * @param string $filename - Filename of the image you want to resize
   */
  public function __construct( $filename )
  {
    if(file_exists($filename))
    {
      $this->setImage( $filename );
    } else {
      throw new Exception('Image ' . $filename . ' can not be found, try another image.');
    }
  }

  /**
   * Set the image variable by using image create
   *
   * @param string $filename - The image filename
   */
  private function setImage( $filename )
  {
    $size = getimagesize($filename);
    $this->ext = $size['mime'];

    switch($this->ext)
      {
        // Image is a JPG
          case 'image/jpg':
          case 'image/jpeg':
            // create a jpeg extension
              $this->image = imagecreatefromjpeg($filename);
              break;

          // Image is a GIF
          case 'image/gif':
              $this->image = @imagecreatefromgif($filename);
              break;

          // Image is a PNG
          case 'image/png':
              $this->image = @imagecreatefrompng($filename);
              break;

          // Mime type not found
          default:
              throw new Exception("File is not an image, please use another file type.", 1);
      }

      $this->origWidth = imagesx($this->image);
      $this->origHeight = imagesy($this->image);
  }

  /**
   * Save the image as the image type the original image was
   *
   * @param  String[type] $savePath     - The path to store the new image
   * @param  string $imageQuality     - The qulaity level of image to create
   *
   * @return Saves the image
   */
  public function saveImage($savePath, $imageQuality="100", $download = false)
  {
      switch($this->ext)
      {
          case 'image/jpg':
          case 'image/jpeg':
            // Check PHP supports this file type
              if (imagetypes() & IMG_JPG) {
                  imagejpeg($this->newImage, $savePath, $imageQuality);
              }
              break;

          case 'image/gif':
            // Check PHP supports this file type
              if (imagetypes() & IMG_GIF) {
                  imagegif($this->newImage, $savePath);
              }
              break;

          case 'image/png':
              $invertScaleQuality = 9 - round(($imageQuality/100) * 9);

              // Check PHP supports this file type
              if (imagetypes() & IMG_PNG) {
                  imagepng($this->newImage, $savePath, $invertScaleQuality);
              }
              break;
      }

      if($download)
      {
        header('Content-Description: File Transfer');
      header("Content-type: application/octet-stream");
      header("Content-disposition: attachment; filename= ".$savePath."");
      readfile($savePath);
      }

      imagedestroy($this->newImage);
  }

  /**
   * Resize the image to these set dimensions
   *
   * @param  int $width         - Max width of the image
   * @param  int $height        - Max height of the image
   * @param  string $resizeOption - Scale option for the image
   *
   * @return Save new image
   */
  public function resizeTo( $width, $height, $resizeOption = 'default' )
  {
    switch(strtolower($resizeOption))
    {
      case 'exact':
        $this->resizeWidth = $width;
        $this->resizeHeight = $height;
      break;

      case 'maxwidth':
        $this->resizeWidth  = $width;
        $this->resizeHeight = $this->resizeHeightByWidth($width);
      break;

      case 'maxheight':
        $this->resizeWidth  = $this->resizeWidthByHeight($height);
        $this->resizeHeight = $height;
      break;

      default:
        if($this->origWidth > $width || $this->origHeight > $height)
        {
          if ( $this->origWidth > $this->origHeight ) {
               $this->resizeHeight = $this->resizeHeightByWidth($width);
               $this->resizeWidth  = $width;
          } else if( $this->origWidth < $this->origHeight ) {
            $this->resizeWidth  = $this->resizeWidthByHeight($height);
            $this->resizeHeight = $height;
          }  else {
            $this->resizeWidth = $width;
            $this->resizeHeight = $height;
          }
        } else {
                $this->resizeWidth = $width;
                $this->resizeHeight = $height;
            }
      break;
    }

    $this->newImage = imagecreatetruecolor($this->resizeWidth, $this->resizeHeight);
      imagecopyresampled($this->newImage, $this->image, 0, 0, 0, 0, $this->resizeWidth, $this->resizeHeight, $this->origWidth, $this->origHeight);
  }

  /**
   * Get the resized height from the width keeping the aspect ratio
   *
   * @param  int $width - Max image width
   *
   * @return Height keeping aspect ratio
   */
  private function resizeHeightByWidth($width)
  {
    return floor(($this->origHeight/$this->origWidth)*$width);
  }

  /**
   * Get the resized width from the height keeping the aspect ratio
   *
   * @param  int $height - Max image height
   *
   * @return Width keeping aspect ratio
   */
  private function resizeWidthByHeight($height)
  {
    return floor(($this->origWidth/$this->origHeight)*$height);
  }
}
?>
  <style media="all">
  #filelist{
  margin-left:auto;
  margin-right:auto;
  max-width:280px;
}
    #varos_kiv2{
      display:inline-flex;
      list-style-type: none;
    /*   margin: 0; */
    /*   width:600px; */
  }
  #varos_kiv2 li input{
      display:block;
      height:20px;
      width: 20px;
  }
  #varos_kiv2 li{
      padding-right:20px;
  }
  tr.blue{
		background-color:#007cc4 !important;
		color:white;
	}
    .blue {
      background-color: #00b2ff !important;
      color: white;
      font-weight: 700;
    }

    .green {
      background-color: #00c71a !important;
      color: white;
      font-weight: 700;
    }

    .orange {
      background-color: #d79b00 !important;
      color: white;
      font-weight: 700;
    }

    .red {
      background-color: #c40000 !important;
      color: white;
      font-weight: 700;
    }

    * {
      font-size: 12px !important;
    }
    .okbox{
      background: url('../img/tick.png') no-repeat;
      background-position:95% 50% !important;
      background-size:20px 20px;
  }

    input[type="radio"], input[type="checkbox"] {
      border: none !important;
      max-height: 20px;
      box-shadow: none;
    }

    input[type="radio"]:focus {
      box-shadow: none;
    }

    #main_wrap {
      max-width: 816px;
      margin-left: auto;
      margin-right: auto;
    }

    #main_wrap td,
    #main_wrap th {
      text-align: center !important;
    }

    #imgform {
      margin-left: auto;
      margin-right: auto;
    }

    #message {
      text-align: left;
    }

    #piczoom {
      position: fixed;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      background-color: rgba(0, 0, 0, 0.7);
      z-index: 999;
    }

    #piczoom img {
      height: 100%;
      cursor: pointer;
    }

    #pics img:hover {
      filter: brightness(50%);
    }
    .hmfrm{
      display: initial !important;
      width: 70% !important;
    }
    .form-control:not([type="radio"]){
      max-width:80% !important;
  }

  </style>
  <script src="js/plupload.full.min.js"></script>
  <script src="js/jquery.plupload.queue/jquery.plupload.queue.js"></script>
  <script>
    function check_fishsum(id, kivn) {
      curbox = $('#' + id + ' input[data-kivn="' + kivn + '"]:not([name="vragxia_rodina[]"]):not([name="matia_lampera[]"])');
      sum = 0;
      $(curbox).each(function() {
        if ($(this).val() != '') {
          sum += parseInt($(this).val());
        }
      })
      ar_psar = $('[name="ar_psariwn[]"]')[kivn];
      if ($(ar_psar).val() != '') {
        if (sum > parseInt($(ar_psar).val())) {
          $('#' + id + ' input[data-kivn="' + kivn + '"]:not([name="vragxia_rodina[]"]):not([name="matia_lampera[]"])').addClass('red');
        } else {
          $('#' + id + ' input[data-kivn="' + kivn + '"]:not([name="vragxia_rodina[]"]):not([name="matia_lampera[]"])').removeClass('red');
        }
        if (id == 'vragxia') {
          current = $('#' + id + ' input[name="vragxia_rodina[]"]')[kivn];
          $(current).val($(ar_psar).val() - sum);
        } else if (id == 'matia') {
          current = $('#' + id + ' input[name="matia_lampera[]"]')[kivn];
          $(current).val($(ar_psar).val() - sum);
        }
      }
    }

    function zoom(url) {
      $('#piczoom').html('<img src="uploads/images/' + url + '" />');
      $('#piczoom').show();
    }

    function check_totals(show_total=true){
      var box = 0;
      var total = [];
      var filter = /(\d+)[/]?(\d+)?[+]?/;
      var qty = $('[name="megethos"]').val();
      qty = filter.exec(qty);
      $('[name^="par_kiv"]').each(function(){
        box = $(this).data('order');
        num = parseInt($(this).val());
        $(this).removeClass('red green blue');
        if(!isNaN(num)){
          if($(this).val()!=""){
            if($(this).val()<parseInt(qty[1])*100){
              $(this).addClass('red');
            } else if ($(this).val()>parseInt(qty[2])*100) {
              $(this).addClass('blue');
            } else {
              $(this).addClass('green');
            }
          }
          if(typeof total[box] == 'undefined') {
            total[box]=num;
          } else {
            total[box]+=num;
          }
        }
        if(show_total==true){
          $('#athr'+box+' input').val(total[box]);
        }
      })


    }

   $(document).ready(function() {
     check_totals(false);
     <?php if(!isset($_GET['type']) || $_GET['type']!='viewall'){ ?>
       document.title = "E - "+$('[name=eidos]').val()+$('[name=megethos]').val();
       $('[name=eidos],[name=megethos]').on('change', function(){
         document.title = "E - "+$('[name=eidos]').val()+$('[name=megethos]').val();
       })
     <?php } ?>

     $('[name^="par_kiv"]').on('change', function(){
      check_totals();
     });

      $('.arpsar').on('keyup change propertychange', function(){
         kivn = parseInt($(this).data('kivn'));
         check_fishsum('matia',kivn);
         check_fishsum('vragxia',kivn);
      })
      $('#toggle_partbl').on('click',function(){
         $('#partbl_body').toggle();
         if($('#toggle_partbl2').hasClass('glyphicon-plus')){
            $('#toggle_partbl2').switchClass('glyphicon-plus', 'glyphicon-minus');
         } else {
            $('#toggle_partbl2').switchClass('glyphicon-minus', 'glyphicon-plus');
         }

      })

      // $("#uploadimage").on('submit',(function(e) {
      //  e.preventDefault();
      //  $("#message").html('Uploading, please wait..');
      //  $('#loading').show();
      //  $.ajax({
      //    url: "ajax_php_file.php", // Url to which the request is send
      //    type: "POST",             // Type of request to be send, called as method
      //    data: new FormData(this), // Data sent to server, a set of key/value pairs (i.e. form fields and values)
      //    contentType: false,       // The content type used when sending data to the server.
      //    cache: false,             // To unable request pages to be cached
      //    processData:false,
      //    dataType: 'json',       // To send DOMDocument or non processed data file it is set to false
      //    success: function(data){   // A function to be called if request succeeds
      //      var info = data['info'];
      //      var target = data['target'];
      //      $('#loading').hide();
      //      $('#picinp').val(target);
      //      $("#message").html(info);
      //    }
      //  });
      // }));
      var uploader = new plupload.Uploader({
        runtimes: 'html5,flash,silverlight,html4',

        browse_button: 'pickfiles', // you can pass in id...
        container: document.getElementById('upcontainer'), // ... or DOM Element itself

        url: "js/upload.php",
        chunk_size: '1mb',

        filters: {
          max_file_size: '10mb',
          mime_types: [{
            title: "Image files",
            extensions: "jpg,gif,png"
          }, {
            title: "Zip files",
            extensions: "zip"
          }]
        },

        // Flash settings
        flash_swf_url: 'js/Moxie.swf',

        // Silverlight settings
        silverlight_xap_url: 'js/Moxie.xap',


        init: {
          PostInit: function() {
            document.getElementById('filelist').innerHTML = '';

            document.getElementById('uploadfiles').onclick = function() {
              uploader.start();
              return false;
            };
          },


          FilesAdded: function(up, files) {
            var filesarr = new Array();
            if($('#picinp').val()!=''){
              filesarr = JSON.parse($('#picinp').val());
            }
            plupload.each(files, function(file) {
              document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></div>';
                if(filesarr.indexOf(file.name)==-1){
                  filesarr.push(file.name);
              }
              uploader.bind('UploadComplete', function() {
                if (uploader.files.length == (uploader.total.uploaded + uploader.total.failed)) {
                    $("#"+file.id).css({"color":"green", "font-weight" : "800"});
                    $("#"+file.id).addClass('okbox');
                }
              });
            });
            $('#picinp').val(JSON.stringify(filesarr));
          },

          UploadProgress: function(up, file) {
            document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
          },

          Error: function(up, err) {
            document.getElementById('console').innerHTML += "\nError #" + err.code + ": " + err.message;
          }
        }
      });

      uploader.init();


      $('.varos').on('keyup change propertychange', function() {
        $('#varos_kiv2 input').each(function(i) {
          elemnt = $('#varos_kiv2 input')[i];
          if ($(elemnt).is(':checked')) {
            varos = parseInt($(elemnt).val());
          }
        })
        if (typeof(varos) !== 'undefined') {
          cv = $(this).val();
          if(cv%1==0){
            len = cv.toString().length;
            // console.log(cv+' / '+'(10 ^ ('+len+'))='+cv / (Math.pow(10, (len-1))));
            cv = cv / (Math.pow(10, (len-1)));

          }
          // console.log(cv);
          $(this).removeClass('green orange red');
          varr = (varos * (1.5 / 100)) + varos;
          //              console.log(varr);
          //              console.log($(this).val());
          if (cv>=varos && cv<=varr && cv!="") {
            $(this).addClass('green');
          } else if (varr < cv && cv!="") {
            $(this).addClass('orange');
          } else if (varr > cv && cv!="") {
            $(this).addClass('red');
          }
        }
      })

    $('input, select').on('keyup change propertychange', function(){
    if($(this).val() && !$(this).hasClass('red')){
      $(this).addClass('okbox');
    } else {
      $(this).removeClass('okbox');
    }
  })

      $('[name="pagos_kg[]"]').on('keyup change propertychange', function() {
        if($('#varos_kiv2 input').is(':checked')){
        cent = 0;
        $('#varos_kiv2 input').each(function(i) {
          elemnt = $('#varos_kiv2 input')[i];
          if ($(elemnt).is(':checked')) {
            varos = $(elemnt).val();
          }
        })

        index = $(this).data('order');
        curpercent = $('[name="posothta_pagou[]"]')[index];
        if ($('select[name="eidos_kiv"]').val() != 'Καστράκι' && $('select[name="eidos_kiv"]').val()!="") {
          if (varos == 10) {
            cent = (($(this).val() / (5) * 100)).toFixed(2);
            $(curpercent).val(cent);
          } else if (varos == 6) {
            cent = (($(this).val() / (3) * 100)).toFixed(2);
            $(curpercent).val(cent);
          } else if (varos == 3) {
            cent = (($(this).val() / (1.5) * 100)).toFixed(2);
            $(curpercent).val(cent);
          }
        } else {
          if (varos == 10) {
            cent = (($(this).val() / (2.5) * 100)).toFixed(2);
            $(curpercent).val(cent);
          } else if (varos == 6) {
            cent = (($(this).val() / (1.5) * 100)).toFixed(2);
            $(curpercent).val(cent);
          } else if (varos == 3) {
            cent = (($(this).val() / (0.75) * 100)).toFixed(2);
            $(curpercent).val(cent);
          }
        }
        $(curpercent).removeClass('green orange red');
        if (cent >= 80 && cent <= 100) {
          $(curpercent).addClass('green');
        } else if (cent < 80 && cent >= 60) {
          $(curpercent).addClass('orange');
        } else if (cent < 60) {
          $(curpercent).addClass('red');
        } else {
          $(curpercent).addClass('green');
        }
        }
      });

      $('input[name="therm_psariwn[]"]').on('keyup change propertychange', function() {
        $('input[name="therm_psariwn[]"]').removeClass('red green');
        $('input[name="therm_psariwn[]"]').each(function() {
          if ($(this).val() < 0 || $(this).val() > 2 && $(this).val() != '') {
            $(this).addClass('red');
          } else if ($(this).val() >= 0 && $(this).val() <= 2 && $(this).val() != '') {
            $(this).addClass('green');
          }
        })
      })

      $('#aimatwmata input, #vragxia input, #matia input, #dusmorfies input, #apobolh input, #alloiwseis input, #parasita input, #upomege8h input, #upermege8h input').on('keyup change propertychange', function() {
        id = $(this).parents('[data-type="cat"]').prop('id');
        kivn = parseInt($(this).data('kivn'));
        // console.log('id: '+id+' kivn: '+kivn);
        check_fishsum(id, kivn);
      })

      $('.rating').on('change', function() {
        rate = 0;
        checked = 0;
        $('.rating').each(function() {
          if ($(this).is(':checked')) {
            checked++;
            rate += parseInt($(this).val());
          }
        })
        if (checked == 3) {
          $('.ratings').each(function() {
            $(this).removeClass('blue green orange red');
          })
          if (rate > 9 && rate < 13) {
            ratelem = $('.ratings')[0];
            $(ratelem).addClass('blue');
            $('#freskothta').val('EXTRA');
            $('#form-submit').prop('disabled', false);
          } else if (rate > 6 && rate < 10) {
            ratelem = $('.ratings')[1];
            $(ratelem).addClass('green');
            $('#freskothta').val('A');
            $('#form-submit').prop('disabled', false);
          } else if (rate > 3 && rate < 7) {
            ratelem = $('.ratings')[2];
            $(ratelem).addClass('orange');
            $('#freskothta').val('B');
            $('#form-submit').prop('disabled', false);
          } else if (rate < 4) {
            ratelem = $('.ratings')[3];
            $(ratelem).addClass('red');
            $('#freskothta').val('REJECTED');
            $('#form-submit').prop('disabled', true);
          }
        }
      });

      $('#piczoom').on('click', function() {
        $('#piczoom').hide();
      });

    });

    // Custom example logic
    function approve(id){
  		$.ajax({
  			method: 'POST',
  			url: 'toDB.php',
  			data: {id: id, user: '<?php echo $_SESSION['susername']; ?>', approve: 1, control: 1},
  			success: function(r){
  				if(r==""){
  					alertify.success('Η Ενέργεια ολοκληρώθηκε επιτυχώς!');
  				} else {
  					alertify.error(r);
  				}
  				$('#container').load(document.URL + ' #viewall',function(){
  					$('.datatable').DataTable();
  				});
  			}
  		})
  	}

  </script>

  <?php

if(!isset($_GET['type']) || $_GET['type']=='new'){
  $qry = "SELECT * FROM companies";
  $qry2 = "SELECT * FROM packing";
  $qrymon = "SELECT * FROM monada";
  $res = mysqli_query($dbC,$qry);
  $res2 = mysqli_query($dbC,$qry2);
  $resmon = mysqli_query($dbC,$qrymon);
?>
<form id="uploadimage" action="" method="post" enctype="multipart/form-data">
</form>
<div id="main_wrap">
   <form name="control_form" id="main_form" action="control_parse.php" method="POST">
      <div id="head" style="width:100%;text-align:center;">
         <table class="table table-striped table-bordered table-condensed  table-responsive">
            <tr>
               <th colspan="4">Ημ/νία Παραλαβής</th>
            </tr>
            <tr>
               <td colspan="4"><input class="form-control hmfrm" type="date" name="hm_paralav" />&nbsp;Καμία ημερομηνία&nbsp;<input class="incheck" type="checkbox" class="form-control" name="hm_paralav2" value="-"/> </td>
            </tr>
            <tr>
               <th>Εταιρία</th>
               <th>Μονάδα Πάχυνσης</th>
               <th>Συσκευαστήριο</th>
            </tr>
            <tr>
               <td>
                  <select class="form-control" name="etairia">
                     <?php
                       while($row=mysqli_fetch_array($res)){
                         echo "<option data-compid=\"".$row['id']."\">".$row['company_name']."</option>";
                       }
                     ?>
                  </select>
               </td>
               <td>
                  <select class="form-control selectpicker" data-size="8" name="monada_paxunshs" data-show-subtext="true" data-live-search="true">
                     <?php
                        while($rowmon=mysqli_fetch_array($resmon)){
                          echo "<option>".$rowmon['text']."</option>";
                        }
                     ?>
                  </select>
               </td>
               <td>
                  <select class="form-control selectpicker" data-size="8" name="kwd_sus" id="susk_opt" data-show-subtext="true" data-live-search="true">
                     <?php
                     	while($row=mysqli_fetch_array($res2)){
                     		echo "<option>".$row['text']."</option>";
                     	}
                     ?>
                  </select>
               </td>
            </tr>
            <tr>
               <th>Ετικετέζα</th>
               <th>Μετατόπιση</th>
               <th>Ελεγκτής</th>
            </tr>
            <tr>
               <td>
                  <select class="form-control" name="etiketeza">
                     <option>-</option>
                     <option>A</option>
                     <option>B</option>
                     <option>D</option>
                     <option>E</option>
                     <option>F</option>
                     <option>K</option>
                     <option>L</option>
                     <option>M</option>
                     <option>N</option>
                     <option>O</option>
                     <option>P</option>
                     <option>Q</option>
                     <option>R</option>
                     <option>S</option>
                     <option>T</option>
                     <option>TW</option>
                     <option>Z</option>
                     <option>KL</option>
                     <option>LR</option>
                     <option>LV</option>
                     <option>Δεν αναγράφεται</option>
                  </select>
               </td>
               <td>
                  <select class="form-control" name="metatopish">
                     <option>Όχι</option>
                     <option>1 ημέρα</option>
                     <option>2 ημέρες</option>
                     <option>3 ημέρες</option>
                     <option>4 ημέρες</option>
                     <option>5 ημέρες</option>
                     <option>6 ημέρες</option>
                     <option>7 ημέρες</option>
                     <option>Άλλο</option>
                  </select>
               </td>
               <td>
                  <select class="form-control" name="elegkths">
                     <option>Άλλο</option>
                     <option>Σταμάτης Κώστας</option>
                     <option>Πετούση Ελίνα</option>
                     <option>Καλλιμάνη Ελένη</option>
                  </select>
            </tr>
         </table>
         <table border="1" style="width:100%;text-align:center;" class="table table-striped table-bordered table-condensed  table-responsive">
            <tbody>
               <tr>
                  <th>Ημ/νία Ελέγχου</th>
                  <th>Ώρα Ελέγχου</th>
                  <!-- <th>Ημ/νία Λήξης/Παραγωγής</th> -->
                  <th>Ημερομηνία Λήξης - Παραγωγής</th>
               </tr>
               <tr>
                  <td>
                     <input class="form-control" type="date" name="hm_elegxou" value="<?php echo date('Y-m-d'); ?>"/>
                  </td>
                  <!-- <td><input class="form-control" type="date" name="hm_lixpar" /></td> -->
                   <!-- <th>Ώρα Παραλαβής</th> -->
                  <td>
                     <input class="form-control" type="time" name="wra_elegxou" value="<?php echo date('G:i'); ?>"/>
                  </td>
                  <!-- <td><input class="form-control" type="time" name="wra_paralavhs" /></td> -->
                  <!-- <th>Ώρα Παραλαβής</th> -->
                  <td>
                     <input class="form-control hmfrm" type="date" name="hm_lixpar"/>&nbsp;Καμία Ημ/νία&nbsp;<input class="incheck" type="checkbox" name="no_lixpar" class="form-control"/>
                  </td>
                  <!-- <td><input class="form-control" type="time" name="wra_paralavhs" /></td> -->
              </tr>

            </tbody>
         </table>
         <table class="table table-striped table-bordered table-condensed  table-responsive">
            <tr>
               <th>Είδος/Μέγεθος Ψαριών</th>
               <th>Κιβώτιο</th>
               <th>Είδος Κιβωτίου</th>
               <th>Παρτίδα</th>
            </tr>
            <tr>
               <td>
                 <div class="row">
                   <div class="col-sm-6">
                     <select class="form-control" name="eidos">
                        <option>Λ</option>
                        <option>Τ</option>
                        <option>Άλλο</option>
                     </select>
                   </div>
                   <div class="col-sm-6">
                     <select class="form-control" name="megethos">
                        <option>2/3</option>
                        <option>3/4</option>
                        <option>4/6</option>
                        <option>6/8</option>
                        <option>8/1000</option>
                        <option>1000+</option>
                        <option>1500+</option>
                        <option>Άλλο</option>
                     </select>
                   </div>
                 </div>

               </td>
               <td>
                  <ul id="varos_kiv2">
                     <li>10 <input class="form-control" type="radio" name="varos_kiv2" value="10" /></li>
                     <li>6 <input class="form-control" type="radio" name="varos_kiv2" value="6" /></li>
                     <li>3 <input class="form-control" type="radio" name="varos_kiv2" value="3" /></li>
                  </ul>
               </td>
               <td>
                  <select class="form-control" name="eidos_kiv">
                     <option>Κανονικό</option>
                     <option>Ροκάκι</option>
                     <option>Καστράκι</option>
                  </select>
               </td>
               <td colspan="4"><input class="form-control" type="number" name="partida" /></td>
            </tr>
         </table>
      </div>
         <div class="panel panel-default">
            <div class="panel-body">
               <div class="row">
                  <div class="col-sm-12">
                     <div class="checkbox">
                        <label><input type="checkbox" value="1" name="apousia_swmatwn"> Απουσία ξένων σωμάτων</label>
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <div class="panel panel-default">
            <div class="panel-heading" id="toggle_partbl" style="cursor:pointer;">Πίνακας Παραγωγής <span class="pull-right"><i id="toggle_partbl2" class="glyphicon glyphicon-plus"></i></span></div>
            <div class="panel-body" style="display: none;" id="partbl_body">
               <table class="table table-striped table-responsive table-bordered">
                  <thead>
                     <tr>
                        <th></th>
                        <th>Κιβώτιο 1</th>
                        <th>Κιβώτιο 2</th>
                        <th>Κιβώτιο 3</th>
                        <th>Κιβώτιο 4</th>
                     </tr>
                  </thead>
                  <tbody>
                     <?php
                        for($y=1;$y<=40;$y++){
                           echo
                           "<tr>
                              <td>".$y."</td>
                              <td><center><input class=\"form-control\" type='number' data-order='1' name='par_kiv1[]' /></center></td>
                              <td><center><input class=\"form-control\" type='number' data-order='2' name='par_kiv2[]' /></center></td>
                              <td><center><input class=\"form-control\" type='number' data-order='3' name='par_kiv3[]' /></center></td>
                              <td><center><input class=\"form-control\" type='number' data-order='4' name='par_kiv4[]' /></center></td>
                           </tr>";
                        }
                     ?>
                     <tfoot>
                       <tr>
                         <td>sum</td>
                         <td id="athr1"><center><input class="form-control" name="pinsum[]" type="number" /></center></td>
                         <td id="athr2"><center><input class="form-control" name="pinsum[]" type="number" /></center></td>
                         <td id="athr3"><center><input class="form-control" name="pinsum[]" type="number" /></center></td>
                         <td id="athr4"><center><input class="form-control" name="pinsum[]" type="number" /></center></td>
                       </tr>
                     </tfoot>
                  </tbody>
               </table>
            </div>
         </div>

         <div id="left_col">
            <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
               <tr>
                  <th></th>
                  <th>Κιβ. 1</th>
                  <th>Κιβ. 2</th>
                  <th>Κιβ. 3</th>
                  <th>Κιβ. 4</th>
               </tr>
               <tr>
                  <th>S/N Κιβωτίου</th>
                  <td><input class="form-control" type="text" value="-" name="sn_kib[]" /></td>
                  <td><input class="form-control" type="text" value="-" name="sn_kib[]" /></td>
                  <td><input class="form-control" type="text" value="-" name="sn_kib[]" /></td>
                  <td><input class="form-control" type="text" value="-" name="sn_kib[]" /></td>
               </tr>
               <tr>
                  <th>Ποσότητα Πάγου %</th>
                  <td><input class="form-control" type="number" step="0.001" name="posothta_pagou[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="posothta_pagou[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="posothta_pagou[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="posothta_pagou[]" /></td>
               </tr>
               <tr>
                  <th>Ποσότητα Πάγου σε Kg</th>
                  <td><input class="form-control" type="number" step="0.001" data-order="0" name="pagos_kg[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" data-order="1" name="pagos_kg[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" data-order="2" name="pagos_kg[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" data-order="3" name="pagos_kg[]" /></td>
               </tr>
               <tr>
                  <th>Θερμοκρασία Κιβωτίου</th>
                  <td><input class="form-control" type="number" step="0.001" name="therm_kiv[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="therm_kiv[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="therm_kiv[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="therm_kiv[]" /></td>
               </tr>
               <tr>
                  <th>Θερμοκρασία Ψαριού</th>
                  <td><input class="form-control" type="number" step="0.001" name="therm_psariwn[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="therm_psariwn[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="therm_psariwn[]" /></td>
                  <td><input class="form-control" type="number" step="0.001" name="therm_psariwn[]" /></td>
               </tr>
               <tr>
                  <th>Αριθμός Ψαριών</th>
                  <td><input class="form-control arpsar" data-kivn="0" type="number" name="ar_psariwn[]" /></td>
                  <td><input class="form-control arpsar" data-kivn="1" type="number" name="ar_psariwn[]" /></td>
                  <td><input class="form-control arpsar" data-kivn="2" type="number" name="ar_psariwn[]" /></td>
                  <td><input class="form-control arpsar" data-kivn="3" type="number" name="ar_psariwn[]" /></td>
               </tr>
               <tr>
                  <th>Αναγραφόμενο Βάρος Κιβωτίου</th>
                  <td><input class="form-control varos" type="number" step="0.001" name="varos_kiv[]" /></td>
                  <td><input class="form-control varos" type="number" step="0.001" name="varos_kiv[]" /></td>
                  <td><input class="form-control varos" type="number" step="0.001" name="varos_kiv[]" /></td>
                  <td><input class="form-control varos" type="number" step="0.001" name="varos_kiv[]" /></td>
               </tr>
               <tr id="apobolh" data-type="cat">
                  <th>Αποβολή Τροφής</th>
                  <td><input class="form-control" data-kivn="0" type="number" name="apobolh_trofhs[]" /></td>
                  <td><input class="form-control" data-kivn="1" type="number" name="apobolh_trofhs[]" /></td>
                  <td><input class="form-control" data-kivn="2" type="number" name="apobolh_trofhs[]" /></td>
                  <td><input class="form-control" data-kivn="3" type="number" name="apobolh_trofhs[]" /></td>
               </tr>
               <tr id="upomege8h" data-type="cat">
                  <th>Υπομεγέθη</th>
                  <td><input class="form-control" data-kivn="0" type="number" name="upomege8h[]" /></td>
                  <td><input class="form-control" data-kivn="1" type="number" name="upomege8h[]" /></td>
                  <td><input class="form-control" data-kivn="2" type="number" name="upomege8h[]" /></td>
                  <td><input class="form-control" data-kivn="3" type="number" name="upomege8h[]" /></td>
               </tr>
               <tr id="upermege8h" data-type="cat">
                  <th>Υπερμεγέθη</th>
                  <td><input class="form-control" data-kivn="0" type="number" name="upermege8h[]" /></td>
                  <td><input class="form-control" data-kivn="1" type="number" name="upermege8h[]" /></td>
                  <td><input class="form-control" data-kivn="2" type="number" name="upermege8h[]" /></td>
                  <td><input class="form-control" data-kivn="3" type="number" name="upermege8h[]" /></td>
               </tr>
               <tr id="aimatwmata" data-type="cat">
                  <th>Αιματώματα</th>
                  <td colspan="4">
                     <table border="0" class="table table-striped table-bordered table-condensed ">
                        <tr>
                           <th>Κεφαλή</th>
                           <td>
                              <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
                                 <tr>
                                    <th>Ελαφρά</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="kefalh_elafra[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="kefalh_elafra[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="kefalh_elafra[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="kefalh_elafra[]" /></td>
                                 </tr>
                                 <tr>
                                    <th>Μεσαία</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="kefalh_mesaia[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="kefalh_mesaia[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="kefalh_mesaia[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="kefalh_mesaia[]" /></td>
                                 </tr>
                                 <tr>
                                    <th>Έντονα</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="kefalh_entona[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="kefalh_entona[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="kefalh_entona[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="kefalh_entona[]" /></td>
                                 </tr>
                              </table>
                           </td>
                        </tr>
                        <tr>
                           <th>Κοιλιά</th>
                           <td>
                              <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
                                 <tr>
                                    <th>Κηλίδες</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="koilia_khlides[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="koilia_khlides[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="koilia_khlides[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="koilia_khlides[]" /></td>
                                 </tr>
                                 <tr>
                                    <th>Στικτά</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="koilia_stikta[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="koilia_stikta[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="koilia_stikta[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="koilia_stikta[]" /></td>
                                 </tr>
                                 <tr>
                                    <th>Διάχυτα</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="koilia_diaxuta[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="koilia_diaxuta[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="koilia_diaxuta[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="koilia_diaxuta[]" /></td>
                                 </tr>
                              </table>
                           </td>
                        </tr>
                        <tr>
                           <th>Σώμα</th>
                           <td>
                              <table class="table table-striped table-bordered table-condensed  table-responsive">
                                 <tr>
                                    <th>Κηλίδες</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="swma_khlides[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="swma_khlides[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="swma_khlides[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="swma_khlides[]" /></td>
                                 </tr>
                                 <tr>
                                    <th>Στικτά</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="swma_stikta[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="swma_stikta[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="swma_stikta[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="swma_stikta[]" /></td>
                                 </tr>
                                 <tr>
                                    <th>Διάχυτα</th>
                                    <td><input class="form-control" data-kivn="0" type="number" name="swma_diaxuta[]" /></td>
                                    <td><input class="form-control" data-kivn="1" type="number" name="swma_diaxuta[]" /></td>
                                    <td><input class="form-control" data-kivn="2" type="number" name="swma_diaxuta[]" /></td>
                                    <td><input class="form-control" data-kivn="3" type="number" name="swma_diaxuta[]" /></td>
                                 </tr>
                              </table>
                           </td>
                        </tr>
                     </table>
                  </td>
               </tr>
               <tr id="vragxia" data-type="cat">
                  <th>Βράγχια</th>
                  <td colspan="4">
                     <table class="table table-striped table-bordered table-condensed  table-responsive">
                        <tr>
                           <th>Ρόδινα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_rodina[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_rodina[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_rodina[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_rodina[]" /></td>
                        </tr>
                        <tr>
                           <th>Φαιά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_faia[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_faia[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_faia[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_faia[]" /></td>
                        </tr>
                        <tr>
                           <th>Μ.Ε.Β.Ν.</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_mebn[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_mebn[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_mebn[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_mebn[]" /></td>
                        </tr>
                        <tr>
                           <th>Αιματώματα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_aimat[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_aimat[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_aimat[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_aimat[]" /></td>
                        </tr>
                        <tr>
                           <th>Καφέ</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_kafe[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_kafe[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_kafe[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_kafe[]" /></td>
                        </tr>
                        <tr>
                           <th>Αποχρωματισμένα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_apoxr[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_apoxr[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_apoxr[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_apoxr[]" /></td>
                        </tr>
                        <tr>
                           <th>Βλέννα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_vlenna[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_vlenna[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_vlenna[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_vlenna[]" /></td>
                        </tr>
                        <tr>
                           <th>Αιματηρή Βλέννα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxia_aim_vlenn[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxia_aim_vlenn[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxia_aim_vlenn[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxia_aim_vlenn[]" /></td>
                        </tr>
                     </table>
                  </td>
               </tr>
               <tr id="matia" data-type="cat">
                  <th>Μάτια</th>
                  <td colspan="4">
                     <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
                        <tr>
                           <th>Λαμπερά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="matia_lampera[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="matia_lampera[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="matia_lampera[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="matia_lampera[]" /></td>
                        </tr>
                        <tr>
                           <th>Θολά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="matia_thola[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="matia_thola[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="matia_thola[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="matia_thola[]" /></td>
                        </tr>
                        <tr>
                           <th>Λευκά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="matia_leuka[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="matia_leuka[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="matia_leuka[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="matia_leuka[]" /></td>
                        </tr>
                        <tr>
                           <th>Επουλωμένα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="matia_epoulwmena[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="matia_epoulwmena[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="matia_epoulwmena[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="matia_epoulwmena[]" /></td>
                        </tr>
                        <tr>
                           <th>Τυφλά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="matia_tufla[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="matia_tufla[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="matia_tufla[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="matia_tufla[]" /></td>
                        </tr>
                        <tr>
                           <th>Αιμοραγικά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="matia_aimoragika[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="matia_aimoragika[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="matia_aimoragika[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="matia_aimoragika[]" /></td>
                        </tr>
                     </table>
                  </td>
               </tr>
               <tr id="dusmorfies" data-type="cat">
                  <th>Δυσμορφίες</th>
                  <td colspan="4">
                     <table class="table table-striped table-bordered table-condensed  table-responsive">
                        <tr>
                           <th>Στραβό Στόμα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="stravo_stoma[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="stravo_stoma[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="stravo_stoma[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="stravo_stoma[]" /></td>
                        </tr>
                        <tr>
                           <th>Εξόγκωμα κάτω σιαγώνας</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="eksogkoma_katw[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="eksogkoma_katw[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="eksogkoma_katw[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="eksogkoma_katw[]" /></td>
                        </tr>
                        <tr>
                           <th>Προέκταση κάτω σιαγώνας</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="eksogkoma_panw[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="eksogkoma_panw[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="eksogkoma_panw[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="eksogkoma_panw[]" /></td>
                        </tr>
                        <tr>
                           <th>Παραμορφωμένο κεφάλι</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="paramorf_kefali[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="paramorf_kefali[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="paramorf_kefali[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="paramorf_kefali[]" /></td>
                        </tr>
                        <tr>
                           <th>Κάθετο εμπρός κεφάλι</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="katheto_kefali[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="katheto_kefali[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="katheto_kefali[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="katheto_kefali[]" /></td>
                        </tr>
                        <tr>
                           <th>Παπαγαλάκι</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="papagalaki[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="papagalaki[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="papagalaki[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="papagalaki[]" /></td>
                        </tr>
                        <tr>
                           <th>Μόνο Βραγχιοκάλυμμα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="vragxiokaluma[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="vragxiokaluma[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="vragxiokaluma[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="vragxiokaluma[]" /></td>
                        </tr>
                        <tr>
                           <th>Ραχιτικά</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="raxitika[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="raxitika[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="raxitika[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="raxitika[]" /></td>
                        </tr>
                        <tr>
                           <th>Λόρδωση</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="lordwsh[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="lordwsh[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="lordwsh[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="lordwsh[]" /></td>
                        </tr>
                        <tr>
                           <th>Κοντόχοντρα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="kontoxontra[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="kontoxontra[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="kontoxontra[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="kontoxontra[]" /></td>
                        </tr>
                        <tr>
                           <th>Κλίση ουράς</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="klish_ouras[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="klish_ouras[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="klish_ouras[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="klish_ouras[]" /></td>
                        </tr>
                     </table>
                  </td>
               </tr>

               <tr id="alloiwseis" data-type="cat">
                  <th>Αλλοιώσεις</th>
                  <td colspan="4">
                     <table class="table table-striped table-bordered table-condensed  table-responsive">
                        <tr>
                           <th>Φαγωμένες ουρές/πτερύγια</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="fagwmenes_oures[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="fagwmenes_oures[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="fagwmenes_oures[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="fagwmenes_oures[]" /></td>
                        </tr>
                        <tr>
                           <th>Πληγές & γδαρμένα</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="plhges_gdarmena[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="plhges_gdarmena[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="plhges_gdarmena[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="plhges_gdarmena[]" /></td>
                        </tr>
                     </table>
                  </td>
               </tr>
               <tr id="parasita" data-type="cat">
                  <th>Παράσιτα</th>
                  <td colspan="4">
                     <table class="table table-striped table-bordered table-condensed  table-responsive">
                        <tr>
                           <th>Ψείρες</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="pseires[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="pseires[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="pseires[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="pseires[]" /></td>
                        </tr>
                        <tr>
                           <th>lernanthropus</th>
                           <td><input class="form-control" data-kivn="0" type="number" name="lamanthropus[]" /></td>
                           <td><input class="form-control" data-kivn="1" type="number" name="lamanthropus[]" /></td>
                           <td><input class="form-control" data-kivn="2" type="number" name="lamanthropus[]" /></td>
                           <td><input class="form-control" data-kivn="3" type="number" name="lamanthropus[]" /></td>
                        </tr>
                     </table>
                  </td>
               </tr>
            </table>
         </div>
         <div id="right_col">
            <table border="1" style="text-align: center;" class="table table-striped table-bordered table-condensed  table-responsive">
               <tr>
                  <th>Κατάσταση Δέρματος</th>
                  <th></th>
                  <th>Κατάσταση Οφθαλμού</th>
                  <th></th>
                  <th>Κατάσταση Βραγχίων</th>
                  <th></th>
               </tr>
               <tr>
                  <td>Ζωηρό και ιριδίζον χρώμα χωρίς αποχρωματισμό. <br />Υδαρή και διαυγή επικαλύπτουσα γλοιώδη ουσία.</td>
                  <td>Βαθ.<br />4<br /><input type="radio" class="form-control rating" name="katast_dermatos" value="4" /></td>
                  <td>Κυρτός (bombe). Κερατοειδής διαυγής, <br />κόρη μαύρη και στίλβουσα.</td>
                  <td>Βαθ.<br />4<br /><input type="radio" class="form-control rating" name="katast_ofthalmou" value="4" /></td>
                  <td>Στίλβοντα. Άνευ βλέννας.</td>
                  <td>Βαθ.<br />4<br /><input type="radio" class="form-control rating" name="katast_bragxiwn" value="4" /></td>
               </tr>
               <tr>
                  <td>Ζωηρό χρώμα χωρίς λάμψη. <br />Επικαλύπτουσα γλοιώδη ουσία, ελαφρώς θολή.</td>
                  <td>Βαθ.<br />3<br /><input type="radio" class="form-control rating" name="katast_dermatos" value="3" /></td>
                  <td>Κυρτός ελαφρώς αποκυρτούμενος. <br />Κερατοειδής ελαφρώς αδιαφανής, μαύρη κόρη, θαμπή.</td>
                  <td>Βαθ.<br />3<br /><input type="radio" class="form-control rating" name="katast_ofthalmou" value="3" /></td>
                  <td>Λιγότερο χρωματισμένα. <br />Ελαφρά ίχνη διαυγούς επικαλύπτουσας γλοιώδους ουσίας.</td>
                  <td>Βαθ.<br />3<br /><input type="radio" class="form-control rating" name="katast_bragxiwn" value="3" /></td>
               </tr>
               <tr>
                  <td>Αποχρωματισμένο & θαμπό με<br />θολή γλοιώδης ουσία.</td>
                  <td>Βαθ.<br />2<br /><input type="radio" class="form-control rating" name="katast_dermatos" value="2" /></td>
                  <td>Επίπεδος, αδιαφανής, κόρη διαφανής.</td>
                  <td>Βαθ.<br />2<br /><input type="radio" class="form-control rating" name="katast_ofthalmou" value="2" /></td>
                  <td>Αποχρωματισμένα με ελαφρώς θολή<br />γλοιώδης ουσία.</td>
                  <td>Βαθ.<br />2<br /><input type="radio" class="form-control rating" name="katast_bragxiwn" value="2" /></td>
               </tr>
               <tr>
                  <td>Χρώμα θαμπό. Αδιαφανή επιλύπτουσα γλοιώδη ουσία.</td>
                  <td>Βαθ.<br />1<br /><input type="radio" class="form-control rating" name="katast_dermatos" value="1" /></td>
                  <td>Κοίλος εις το μέσον. <br />Κερατοειδής γαλακτόχρους, κόρη γκρίζα.</td>
                  <td>Βαθ.<br />1<br /><input type="radio" class="form-control rating" name="katast_ofthalmou" value="1" /></td>
                  <td>Κιτρινωπά. <br />Γαλακτόχροα επικαλύπτουσα γλοιώδη ουσία.</td>
                  <td>Βαθ.<br />1<br /><input type="radio" class="form-control rating" name="katast_bragxiwn" value="1" /></td>
               </tr>
            </table>
            <table border="1" id="rate_tbl" style="float:right;" class="table table-bordered table-condensed  table-responsive">
               <tr>
                  <th>Βαθμοί</th>
                  <th>Χαρακτηρισμός</th>
               </tr>
               <tr class="ratings">
                  <td>10 - 12</td>
                  <td>EXTRA</td>
               </tr>
               <tr class="ratings">
                  <td>7 - 9</td>
                  <td>A</td>
               </tr>
               <tr class="ratings">
                  <td>4 - 6</td>
                  <td>B</td>
               </tr>
               <tr class="ratings">
                  <td>4</td>
                  <td>Απορριπτέο</td>
               </tr>
            </table>

            <div id="general">
               <center><b>Γενικά</b></center>
               <table style="float:left;" border="1" class="table table-striped table-bordered table-condensed  table-responsive">
                  <tr>
                     <th>Κατάσταση Σάρκας</th>
                     <th></th>
                     <th>Χρώμα</th>
                     <th></th>
                     <th>Απολέπιση</th>
                     <th></th>
                     <th>Αιματώματα</th>
                     <th></th>
                     <th>Κοιλιά</th>
                  </tr>
                  <tr>
                     <td>Λεία & Υγρή <input class="form-control" type="radio" name="stat_sarkas" value="Λεία & Υγρή" /></td>
                     <td></td>
                     <td>Ιριδίζον <input class="form-control" type="radio" name="stat_xrwma" value="Ιριδίζον" /></td>
                     <td></td>
                     <td>Ελαφρή <input class="form-control" type="radio" name="stat_apolepish" value="Ελαφρή" /></td>
                     <td></td>
                     <td>Κεφαλή <input class="form-control" type="radio" name="stat_aimatwmata" value="Κεφαλή" /></td>
                     <td></td>
                     <td>Κυλινδρική <input class="form-control" type="radio" name="stat_koilia" value="Κυλινδρική" /></td>
                  </tr>
                  <tr>
                     <td>Κέρινη <input class="form-control" type="radio" name="stat_sarkas" value="Κέρινη" /></td>
                     <td></td>
                     <td>Ζωηρό <input class="form-control" type="radio" name="stat_xrwma" value="Ζωηρό" /></td>
                     <td></td>
                     <td>Μεσαία <input class="form-control" type="radio" name="stat_apolepish" value="Μεσαία" /></td>
                     <td></td>
                     <td>Σώμα <input class="form-control" type="radio" name="stat_aimatwmata" value="Σώμα" /></td>
                     <td></td>
                     <td>Διογκωμένη <input class="form-control" type="radio" name="stat_koilia" value="Διογκωμένη" /></td>
                  </tr>
                  <tr>
                     <td>Στεγνή <input class="form-control" type="radio" name="stat_sarkas" value="Στεγνή" /></td>
                     <td></td>
                     <td>Θαμπό <input class="form-control" type="radio" name="stat_xrwma" value="Θαμπό" /></td>
                     <td></td>
                     <td>Έντονη <input class="form-control" type="radio" name="stat_apolepish" value="Έντονη" /></td>
                     <td></td>
                     <td>Περιοχές <input class="form-control" type="radio" name="stat_aimatwmata" value="Περιοχές" /></td>
                     <td></td>
                     <td>Μαλακή <input class="form-control" type="radio" name="stat_koilia" value="Μαλακή" /></td>
                  </tr>
               </table>
            </div>

            <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
               <tr>
                  <th></th>
                  <th>Τυπική</th>
                  <th>Προβληματική</th>
                  <th>Μη Αποδεκτή</th>
                  <th>Διόρθωση</th>
               </tr>
               <tr>
                  <td>Κουρμπάρισμα</td>
                  <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Τυπική" /></td>
                  <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Προβληματική" /></td>
                  <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Μη Αποδεκτή" /></td>
                  <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Διόρθωση" /></td>
               </tr>
               <tr>
                  <td>Κατάσταση Φελιζόλ</td>
                  <td><input class="form-control" type="radio" name="susk_felizol" value="Τυπική" /></td>
                  <td><input class="form-control" type="radio" name="susk_felizol" value="Προβληματική" /></td>
                  <td><input class="form-control" type="radio" name="susk_felizol" value="Μη Αποδεκτή" /></td>
                  <td><input class="form-control" type="radio" name="susk_felizol" value="Διόρθωση" /></td>
               </tr>
               <tr>
                  <td>Κατάσταση Πάγου</td>
                  <td><input class="form-control" type="radio" name="susk_pagos" value="Τυπική" /></td>
                  <td><input class="form-control" type="radio" name="susk_pagos" value="Προβληματική" /></td>
                  <td><input class="form-control" type="radio" name="susk_pagos" value="Μη Αποδεκτή" /></td>
                  <td><input class="form-control" type="radio" name="susk_pagos" value="Διόρθωση" /></td>
               </tr>
               <tr>
                  <td>Κατάσταση Παλέτας</td>
                  <td><input class="form-control" type="radio" name="susk_paleta" value="Τυπική" /></td>
                  <td><input class="form-control" type="radio" name="susk_paleta" value="Προβληματική" /></td>
                  <td><input class="form-control" type="radio" name="susk_paleta" value="Μη Αποδεκτή" /></td>
                  <td><input class="form-control" type="radio" name="susk_paleta" value="Διόρθωση" /></td>
               </tr>
               <tr>
                  <td>Κατάσταση Σήμανσης</td>
                  <td><input class="form-control" type="radio" name="susk_shmansh" value="Τυπική" /></td>
                  <td><input class="form-control" type="radio" name="susk_shmansh" value="Προβληματική" /></td>
                  <td><input class="form-control" type="radio" name="susk_shmansh" value="Μη Αποδεκτή" /></td>
                  <td><input class="form-control" type="radio" name="susk_shmansh" value="Διόρθωση" /></td>
               </tr>
            </table>
            <div class="panel panel-default">
               <div class="panel-body">
                  <div class="row">
                     <div class="col-sm-12">
                        <div class="checkbox">
                           <label><input type="checkbox" value="1" name="apodekth_partida">Η παρτίδα είναι αποδεκτή</label>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <br />
            <div id="filelist">Your browser doesn't have Flash, Silverlight or HTML5 support.</div>

            <div id="upcontainer">
              <a id="pickfiles" href="javascript:;" class="btn btn-default">Select files</a>
              <a id="uploadfiles" href="javascript:;" class="btn btn-default">Upload files</a>
            </div>
            <br />
            <div>
               <p><b>ΠΑΡΑΤΗΡΗΣΕΙΣ: Οι θερμογράφοι να είναι σε ετοιμότητα 24ωρης εγγραφής!!! <br />Σύντομη Περιγραφή του Δείγματος</b></p>
               <textarea class="form-control" name="comment" style="height:200px;width:400px;margin-left: auto;margin-right: auto;"></textarea>
               <br />
               <input class="btn btn-default" type="submit" name="submit" value="Καταχώρηση" style="height:70px;width:200px;margin-left: auto;margin-right: auto;" id="form-submit" />
               <input type="hidden" name="picture" id="picinp" /><input type="hidden" id="freskothta" name="freskothta" value="" />
            </div>
         </div>
      </form>
   </div>

    <?php
} elseif(isset($_GET['type']) && $_GET['type']=='view'){
  $qry = "SELECT * FROM control_form2 WHERE id=".$_GET['id'];
  $res = mysqli_query($dbC, $qry);
  $row = mysqli_fetch_array($res);
  $sn_kiv = json_decode($row['sn_kib'],1);
  $posothta_pagou = json_decode($row['posothta_pagou'],1);
  $pagos_kg = json_decode($row['pagos_kg'],1);
  $therm_kiv = json_decode($row['therm_kiv'],1);
  $therm_psariwn = json_decode($row['therm_psariwn'],1);
  $ar_psariwn = json_decode($row['ar_psariwn'],1);
  $varos_kiv = json_decode($row['varos_kiv'],1);
  $kefalh = json_decode($row['kefalh'],1);
  $koilia = json_decode($row['koilia'],1);
  $swma = json_decode($row['swma'],1);
  $bragxia = json_decode($row['bragxia'],1);
  $matia = json_decode($row['matia'],1);
  $dusmorfies = json_decode($row['dusmorfies'],1);
  $apobolh_trofhs = json_decode($row['apobolh_trofhs'],1);
  $alloiwseis = json_decode($row['alloiwseis'],1);
  $parasita = json_decode($row['parasita'],1);
  $upomege8h = json_decode($row['upomege8h'],1);
  $upermege8h = json_decode($row['upermege8h'],1);
  $pinpar = json_decode($row['pinakas_par']);
  $pinsum = json_decode($row['pinsum']);

$pagos = ['','',''];
$pi = 0;
foreach($posothta_pagou as $pagos_pct){
  if($pagos_pct>=80 && $pagos_pct<=100 && $pagos_pct!=""){
      $pagos[$pi] = 'green';
    } else if($pagos_pct<80 && $pagos_pct>=60 && $pagos_pct!=""){
      $pagos[$pi] = 'orange';
    } else if($pagos_pct<60 && $pagos_pct!=""){
      $pagos[$pi] = 'red';
    } elseif($pagos_pct!="") {
      $pagos[$pi] = 'green';
    }
  $pi++;
}
$tpsarc = ['','','',''];
$pi = 0;
foreach($therm_psariwn as $tpsar){
  if($tpsar>=0 && $tpsar<=2 && $tpsar!=""){
      $tpsarc[$pi] = 'green';
    } elseif($tpsar!="") {
      $tpsarc[$pi] = 'red';
    }
  $pi++;
}

if($row['varos_kiv2']!=''){
  $vk2 = $row['varos_kiv2'];
  $vkiv = ['','','',''];
  $pi = 0;
  foreach($varos_kiv as $kiv){
    if($kiv!="" && fmod($kiv, 1)==0){
      // echo "<script>console.log('".$kiv."');</script>";
      $kiv = $kiv / ( pow( 10, (strlen( (string)$kiv ) -1) ) );
      // echo "<script>console.log('".$kiv."');</script>";
    }
    // echo "<script>console.log('".(($vk2*(1.5/100))+$vk2).", rec: ".$kiv.", kiv%1=".($kiv%1).", type: ".gettype($kiv)."');</script>";
    if($kiv>=$vk2 && $kiv<=(($vk2*(1.5/100))+$vk2) && $kiv!=""){
      $vkiv[$pi]='green';
    } elseif($kiv>($vk2*(1.5/100))+$vk2 && $kiv!=""){
      $vkiv[$pi]='orange';
    } elseif($kiv<($vk2*(1.5/100))+$vk2 && $kiv!=""){
      $vkiv[$pi]='red';
    }
    $pi++;
  }
}

echo '<div id="piczoom" style="display:none;"></div><div id="main_wrap"><form name="control_form" action="control_parse.php" method="POST">
<div id="head" style="width:100%;text-align:center;">
<table border="1" style="width:100%;text-align:center;" class="table table-striped table-bordered table-condensed  table-responsive">
<tbody>
  <tr>
    <th>Ημ/νία Παραλαβής</th>
    <th>Εταιρία</th>
        <th>Συσκευαστήριο</th>
        <th>Μονάδα Πάχυνσης</th>


  </tr>
  <tr>

    <td>'.($row['hm_paralav']!='-' ? date('d-m-Y',strtotime($row['hm_paralav'])) : $row['hm_paralav']).'</td>
    <td>'.$row['etairia'].'</td>
        <td>'.$row['kwd_sus'].'</td>
        <td>'.$row['monada_paxunshs'].'</td>

  </tr>
  <tr>

        <th>Ετικετέζα</th>
        <th>Μετατόπιση</th>
        <th>Ημ/νία Ελέγχου</th>
    <th>Ώρα Ελέγχου</th>
  </tr>
  <tr>

        <td>'.$row['etiketeza'].'</td>
    <td>'.$row['metatopish'].'</td>
        <td>'.($row['hm_elegxou']!='0000-00-00' ? date('d-m-Y',strtotime($row['hm_elegxou'])) : '-').'</td>
        <td>'.$row['wra_elegxou'].'</td>
  </tr>
  <tr>
        <th>Ημερομηνία Λήξης - Παραγωγής</th>
        <th>Ελεγκτής</th>
    <th>Είδος/Μέγεθος</th>
    <th>Κιβώτιο</th>
  </tr>
  <tr>
        <td>'.($row['hm_lixpar']!='0000-00-00' ? date('d-m-Y',strtotime($row['hm_lixpar'])) : '-').'</td>
        <td>'.$row['elegkths'].'</td>
    <td>'.$row['eidos'].$row['megethos'].'
          <input type="hidden" name="eidos" value="'.$row['eidos'].'"  />
          <input type="hidden" name="megethos" value="'.$row['megethos'].'"  />
    </td>
    <td>'.$row['varos_kiv2'].'</td>
  </tr>
</tbody>
</table>
<table style="width:100%;text-align:center;" class="table table-striped table-bordered table-condensed  table-responsive">

    <tr><th>Είδος Κιβωτίου</th></tr>
  <tr><td>'.$row['eidos_kiv'].'</td></tr>

    <tr><th>Παρτίδα</th></tr>
  <tr><td>'.$row['partida'].'</td></tr>
</table>
</div>';
?>

<div class="panel panel-default">
   <div class="panel-heading" style="cursor:pointer;" id="toggle_partbl">Πίνακας Παραγωγής <span class="pull-right"><i id="toggle_partbl2" class="glyphicon glyphicon-plus"></i></span></div>
   <div class="panel-body" style="display: none;" id="partbl_body">
      <table class="table table-striped table-responsive table-bordered">
         <thead>
            <tr>
               <th></th>
               <th>Κιβώτιο 1</th>
               <th>Κιβώτιο 2</th>
               <th>Κιβώτιο 3</th>
               <th>Κιβώτιο 4</th>
            </tr>
         </thead>
         <tbody>
            <?php
               for($y=1;$y<=40;$y++){
                  echo
                  "<tr>
                     <td>".$y."</td>
                     <td><center>".$pinpar[0][$y-1]."</center></td>
                     <td><center>".$pinpar[1][$y-1]."</center></td>
                     <td><center>".$pinpar[2][$y-1]."</center></td>
                     <td><center>".$pinpar[3][$y-1]."</center></td>
                  </tr>";
               }
            ?>
         </tbody>
         <tfoot>
           <tr>
             <td>sum</td>
             <td id="athr1"><center><?php echo $pinsum[0]; ?></center></td>
             <td id="athr2"><center><?php echo $pinsum[1]; ?></center></td>
             <td id="athr3"><center><?php echo $pinsum[2]; ?></center></td>
             <td id="athr4"><center><?php echo $pinsum[3]; ?></center></td>
           </tr>
         </tfoot>
      </table>
   </div>
</div>

<?php
echo '<div id="left_col">
<table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
  <tr>
    <th></th><th>Κιβ. 1</th><th>Κιβ. 2</th><th>Κιβ. 3</th><th>Κιβ. 4</th>
  </tr>
  <tr>
    <th>S/N Κιβωτίου</th><td>'.$sn_kiv[0].'</td><td>'.$sn_kiv[1].'</td><td>'.$sn_kiv[2].'</td><td>'.$sn_kiv[3].'</td>
  </tr>
  <tr>
    <th>Ποσότητα Πάγου %</th><td class="'.$pagos[0].'">'.$posothta_pagou[0].'</td><td class="'.$pagos[1].'">'.$posothta_pagou[1].'</td><td class="'.$pagos[2].'">'.$posothta_pagou[2].'</td><td class="'.$pagos[3].'">'.$posothta_pagou[3].'</td>
  </tr>
  <tr>
    <th>Ποσότητα Πάγου σε Kg</th><td>'.$pagos_kg[0].'</td><td>'.$pagos_kg[1].'</td><td>'.$pagos_kg[2].'</td><td>'.$pagos_kg[3].'</td>
  </tr>
  <tr>
    <th>Θερμοκρασία Κιβωτίου</th><td>'.$therm_kiv[0].'</td><td>'.$therm_kiv[1].'</td><td>'.$therm_kiv[2].'</td><td>'.$therm_kiv[3].'</td>
  </tr>
  <tr>
    <th>Θερμοκρασία Ψαριού</th><td class="'.$tpsarc[0].'">'.$therm_psariwn[0].'</td><td class="'.$tpsarc[1].'">'.$therm_psariwn[1].'</td><td class="'.$tpsarc[2].'">'.$therm_psariwn[2].'</td><td class="'.$tpsarc[3].'">'.$therm_psariwn[3].'</td>
  </tr>
  <tr>
    <th>Αριθμός Ψαριών</th><td>'.$ar_psariwn[0].'</td><td>'.$ar_psariwn[1].'</td><td>'.$ar_psariwn[2].'</td>
  </tr>
  <tr>
    <th>Βάρος Κιβωτίου</th><td class="'.$vkiv[0].'">'.$varos_kiv[0].'</td><td class="'.$vkiv[1].'">'.$varos_kiv[1].'</td><td class="'.$vkiv[2].'">'.$varos_kiv[2].'</td><td class="'.$vkiv[3].'">'.$varos_kiv[3].'</td>
  </tr>
  <tr>
    <th>Αποβολή Τροφής</th>
    <td>'.$apobolh_trofhs[0].'</td>
    <td>'.$apobolh_trofhs[1].'</td>
    <td>'.$apobolh_trofhs[2].'</td>
    <td>'.$apobolh_trofhs[3].'</td>
  </tr>
<tr>
    <th>Υπομεγέθη</th>
    <td>'.$upomege8h[0].'</td>
    <td>'.$upomege8h[1].'</td>
    <td>'.$upomege8h[2].'</td>
    <td>'.$upomege8h[3].'</td>
  </tr>
  <tr>
    <th>Υπερμεγέθη</th>
    <td>'.$upermege8h[0].'</td>
    <td>'.$upermege8h[1].'</td>
    <td>'.$upermege8h[2].'</td>
    <td>'.$upermege8h[3].'</td>
  </tr>
  <tr><th>Αιματώματα</th><td colspan="4">
    <table border="0" class="table table-striped table-bordered table-condensed  table-responsive">
      <tr>
        <th>Κεφαλή</th>
        <td>
          <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
          <tr>
            <th>Ελαφρά</th>
            <td>'.$kefalh['elafra'][0].'</td>
            <td>'.$kefalh['elafra'][1].'</td>
            <td>'.$kefalh['elafra'][2].'</td>
            <td>'.$kefalh['elafra'][3].'</td>
          </tr>
          <tr>
            <th>Μεσαία</th>
            <td>'.$kefalh['mesaia'][0].'</td>
            <td>'.$kefalh['mesaia'][1].'</td>
            <td>'.$kefalh['mesaia'][2].'</td>
            <td>'.$kefalh['mesaia'][3].'</td>
          </tr>
          <tr>
            <th>Έντονα</th>
            <td>'.$kefalh['entona'][0].'</td>
            <td>'.$kefalh['entona'][1].'</td>
            <td>'.$kefalh['entona'][2].'</td>
            <td>'.$kefalh['entona'][3].'</td>
          </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Κοιλιά</th>
        <td>
          <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
          <tr>
            <th>Κηλίδες</th>
            <td>'.$koilia['khlides'][0].'</td>
            <td>'.$koilia['khlides'][1].'</td>
            <td>'.$koilia['khlides'][2].'</td>
            <td>'.$koilia['khlides'][3].'</td>
          </tr>
          <tr>
            <th>Στικτά</th>
            <td>'.$koilia['stikta'][0].'</td>
            <td>'.$koilia['stikta'][1].'</td>
            <td>'.$koilia['stikta'][2].'</td>
            <td>'.$koilia['stikta'][3].'</td>
          </tr>
          <tr>
            <th>Διάχυτα</th>
            <td>'.$koilia['diaxuta'][0].'</td>
            <td>'.$koilia['diaxuta'][1].'</td>
            <td>'.$koilia['diaxuta'][2].'</td>
            <td>'.$koilia['diaxuta'][3].'</td>
          </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Σώμα</th>
        <td>
          <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
          <tr>
            <th>Κηλίδες</th>
            <td>'.$swma['khlides'][0].'</td>
            <td>'.$swma['khlides'][1].'</td>
            <td>'.$swma['khlides'][2].'</td>
            <td>'.$swma['khlides'][3].'</td>
          </tr>
          <tr>
            <th>Στικτά</th>
            <td>'.$swma['stikta'][0].'</td>
            <td>'.$swma['stikta'][1].'</td>
            <td>'.$swma['stikta'][2].'</td>
            <td>'.$swma['stikta'][3].'</td>
          </tr>
          <tr>
            <th>Διάχυτα</th>
            <td>'.$swma['diaxuta'][0].'</td>
            <td>'.$swma['diaxuta'][1].'</td>
            <td>'.$swma['diaxuta'][2].'</td>
            <td>'.$swma['diaxuta'][3].'</td>
          </tr>
          </table>
        </td>
      </tr>

    </table>
    </td>
  </tr>
  <tr>
    <th>Βράγχια</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Ρόδινα</th>
          <td>'.$bragxia['rodina'][0].'</td>
          <td>'.$bragxia['rodina'][1].'</td>
          <td>'.$bragxia['rodina'][2].'</td>
          <td>'.$bragxia['rodina'][3].'</td>
        </tr>
        <tr>
          <th>Φαιά</th>
          <td>'.$bragxia['faia'][0].'</td>
          <td>'.$bragxia['faia'][1].'</td>
          <td>'.$bragxia['faia'][2].'</td>
          <td>'.$bragxia['faia'][3].'</td>
        </tr>
        <tr>
          <th>Μ.Ε.Β.Ν.</th>
          <td>'.$bragxia['mebn'][0].'</td>
          <td>'.$bragxia['mebn'][1].'</td>
          <td>'.$bragxia['mebn'][2].'</td>
          <td>'.$bragxia['mebn'][3].'</td>
        </tr>
        <tr>
          <th>Αιματώματα</th>
          <td>'.$bragxia['aimatwmata'][0].'</td>
          <td>'.$bragxia['aimatwmata'][1].'</td>
          <td>'.$bragxia['aimatwmata'][2].'</td>
          <td>'.$bragxia['aimatwmata'][3].'</td>
        </tr>
        <tr>
          <th>Καφέ</th>
          <td>'.$bragxia['kafe'][0].'</td>
          <td>'.$bragxia['kafe'][1].'</td>
          <td>'.$bragxia['kafe'][2].'</td>
          <td>'.$bragxia['kafe'][3].'</td>
        </tr>
        <tr>
          <th>Αποχρωματισμένα</th>
          <td>'.$bragxia['apoxrwm'][0].'</td>
          <td>'.$bragxia['apoxrwm'][1].'</td>
          <td>'.$bragxia['apoxrwm'][2].'</td>
          <td>'.$bragxia['apoxrwm'][3].'</td>
        </tr>
        <tr>
          <th>Βλέννα</th>
          <td>'.$bragxia['vlenna'][0].'</td>
          <td>'.$bragxia['vlenna'][1].'</td>
          <td>'.$bragxia['vlenna'][2].'</td>
          <td>'.$bragxia['vlenna'][3].'</td>
        </tr>
        <tr>
          <th>Αιματηρή Βλέννα</th>
          <td>'.$bragxia['aim_vlenna'][0].'</td>
          <td>'.$bragxia['aim_vlenna'][1].'</td>
          <td>'.$bragxia['aim_vlenna'][2].'</td>
          <td>'.$bragxia['aim_vlenna'][3].'</td>
        </tr>
      </table>

    </td>
  </tr>
  <tr>
    <th>Μάτια</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Λαμπερά</th>
          <td>'.$matia['lampera'][0].'</td>
          <td>'.$matia['lampera'][1].'</td>
          <td>'.$matia['lampera'][2].'</td>
          <td>'.$matia['lampera'][3].'</td>
        </tr>
        <tr>
          <th>Θολά</th>
          <td>'.$matia['thola'][0].'</td>
          <td>'.$matia['thola'][1].'</td>
          <td>'.$matia['thola'][2].'</td>
          <td>'.$matia['thola'][3].'</td>
        </tr>
        <tr>
          <th>Λευκά</th>
          <td>'.$matia['leuka'][0].'</td>
          <td>'.$matia['leuka'][1].'</td>
          <td>'.$matia['leuka'][2].'</td>
          <td>'.$matia['leuka'][3].'</td>
        </tr>
        <tr>
          <th>Επουλωμένα</th>
          <td>'.$matia['epoulwmena'][0].'</td>
          <td>'.$matia['epoulwmena'][1].'</td>
          <td>'.$matia['epoulwmena'][2].'</td>
          <td>'.$matia['epoulwmena'][3].'</td>
        </tr>
        <tr>
          <th>Τυφλά</th>
          <td>'.$matia['tufla'][0].'</td>
          <td>'.$matia['tufla'][1].'</td>
          <td>'.$matia['tufla'][2].'</td>
          <td>'.$matia['tufla'][3].'</td>
        </tr>
        <tr>
          <th>Αιμοραγικά</th>
          <td>'.$matia['aimoragika'][0].'</td>
          <td>'.$matia['aimoragika'][1].'</td>
          <td>'.$matia['aimoragika'][2].'</td>
          <td>'.$matia['aimoragika'][3].'</td>
        </tr>
      </table>

    </td>
  </tr>
  <tr>
    <th>Δυσμορφίες</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Στραβό Στόμα</th>
          <td>'.$dusmorfies['stravo_stoma'][0].'</td>
          <td>'.$dusmorfies['stravo_stoma'][1].'</td>
          <td>'.$dusmorfies['stravo_stoma'][2].'</td>
          <td>'.$dusmorfies['stravo_stoma'][3].'</td>
        </tr>
        <tr>
          <th>Εξόγκωμα κάτω σιαγώνας</th>
          <td>'.$dusmorfies['eksogkoma_katw'][0].'</td>
          <td>'.$dusmorfies['eksogkoma_katw'][1].'</td>
          <td>'.$dusmorfies['eksogkoma_katw'][2].'</td>
          <td>'.$dusmorfies['eksogkoma_katw'][3].'</td>
        </tr>
        <tr>
          <th>Προέκταση κάτω σιαγώνας</th>
          <td>'.$dusmorfies['proekt_katw'][0].'</td>
          <td>'.$dusmorfies['proekt_katw'][1].'</td>
          <td>'.$dusmorfies['proekt_katw'][2].'</td>
          <td>'.$dusmorfies['proekt_katw'][3].'</td>
        </tr>
        <tr>
          <th>Παραμορφωμένο κεφάλι</th>
          <td>'.$dusmorfies['paramorf_kefali'][0].'</td>
          <td>'.$dusmorfies['paramorf_kefali'][1].'</td>
          <td>'.$dusmorfies['paramorf_kefali'][2].'</td>
          <td>'.$dusmorfies['paramorf_kefali'][3].'</td>
        </tr>
        <tr>
          <th>Κάθετο εμπρός κεφάλι</th>
          <td>'.$dusmorfies['katheto_kefali'][0].'</td>
          <td>'.$dusmorfies['katheto_kefali'][1].'</td>
          <td>'.$dusmorfies['katheto_kefali'][2].'</td>
          <td>'.$dusmorfies['katheto_kefali'][3].'</td>
        </tr>
        <tr>
          <th>Παπαγαλάκι</th>
          <td>'.$dusmorfies['papagalaki'][0].'</td>
          <td>'.$dusmorfies['papagalaki'][1].'</td>
          <td>'.$dusmorfies['papagalaki'][2].'</td>
          <td>'.$dusmorfies['papagalaki'][3].'</td>
        </tr>
        <tr>
          <th>Μόνο Βραγχιοκάλυμμα</th>
          <td>'.$dusmorfies['vragxiokaluma'][0].'</td>
          <td>'.$dusmorfies['vragxiokaluma'][1].'</td>
          <td>'.$dusmorfies['vragxiokaluma'][2].'</td>
          <td>'.$dusmorfies['vragxiokaluma'][3].'</td>
        </tr>
        <tr>
          <th>Ραχιτικά</th>
          <td>'.$dusmorfies['raxitika'][0].'</td>
          <td>'.$dusmorfies['raxitika'][1].'</td>
          <td>'.$dusmorfies['raxitika'][2].'</td>
          <td>'.$dusmorfies['raxitika'][3].'</td>
        </tr>
        <tr>
          <th>Λόρδωση</th>
          <td>'.$dusmorfies['lordwsh'][0].'</td>
          <td>'.$dusmorfies['lordwsh'][1].'</td>
          <td>'.$dusmorfies['lordwsh'][2].'</td>
          <td>'.$dusmorfies['lordwsh'][3].'</td>
        </tr>
        <tr>
          <th>Κοντόχοντρα</th>
          <td>'.$dusmorfies['kontoxontra'][0].'</td>
          <td>'.$dusmorfies['kontoxontra'][1].'</td>
          <td>'.$dusmorfies['kontoxontra'][2].'</td>
          <td>'.$dusmorfies['kontoxontra'][3].'</td>
        </tr>
        <tr>
          <th>Κλίση ουράς</th>
          <td>'.$dusmorfies['klish_ouras'][0].'</td>
          <td>'.$dusmorfies['klish_ouras'][1].'</td>
          <td>'.$dusmorfies['klish_ouras'][2].'</td>
          <td>'.$dusmorfies['klish_ouras'][3].'</td>
        </tr>
      </table>

    </td>
  </tr>

  <tr>
    <th>Αλλοιώσεις</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Φαγωμένες ουρές/πτερύγια</th>
          <td>'.$alloiwseis['fagwmenes_oures'][0].'</td>
          <td>'.$alloiwseis['fagwmenes_oures'][1].'</td>
          <td>'.$alloiwseis['fagwmenes_oures'][2].'</td>
          <td>'.$alloiwseis['fagwmenes_oures'][3].'</td>
        </tr>
        <tr>
          <th>Πληγές & γδαρμένα</th>
          <td>'.$alloiwseis['plhges_gdarmena'][0].'</td>
          <td>'.$alloiwseis['plhges_gdarmena'][1].'</td>
          <td>'.$alloiwseis['plhges_gdarmena'][2].'</td>
          <td>'.$alloiwseis['plhges_gdarmena'][3].'</td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <th>Παράσιτα</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Ψείρες</th>
          <td>'.$parasita['pseires'][0].'</td>
          <td>'.$parasita['pseires'][1].'</td>
          <td>'.$parasita['pseires'][2].'</td>
          <td>'.$parasita['pseires'][3].'</td>
        </tr>
        <tr>
          <th>lernanthropus</th>
          <td>'.$parasita['lamanthropus'][0].'</td>
          <td>'.$parasita['lamanthropus'][1].'</td>
          <td>'.$parasita['lamanthropus'][2].'</td>
          <td>'.$parasita['lamanthropus'][3].'</td>
        </tr>
      </table>
    </td>
  </tr>

</table>
</div>
<div id="right_col">
  <table border="1" style="text-align: center;" class="table table-striped table-bordered table-condensed  table-responsive">
    <tr>
      <th>Κατάσταση Δέρματος</th>
      <th></th>
      <th>Κατάσταση Οφθαλμού</th>
      <th></th>
      <th>Κατάσταση Βραγχίων</th>
      <th></th>
    </tr>
    <tr>
      <td>Ζωηρό ιριδίζον χρώμα, με υδαρή,<br />διαυγή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />4<br /><input class="form-control" type="radio" name="katast_dermatos" value="4" '.($row['katast_dermatos']==4 ? 'checked="checked"' : '').'/></td>
      <td>Κυρτός, διαυγής, κόρη μαύρη και<br />στίλβουσα.</td>
      <td>Βαθ.<br />4<br /><input class="form-control" type="radio" name="katast_ofthalmou" value="4" '.($row['katast_ofthalmou']==4 ? 'checked="checked"' : '').'/></td>
      <td>Στίλβοντα, ρόδινα, άνευ βλέννας</td>
      <td>Βαθ.<br />4<br /><input class="form-control" type="radio" name="katast_bragxiwn" value="4"'.($row['katast_bragxiwn']==4 ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Ζωηρό χρώμα χωρίς λάμψη με<br />ελαφρώς θολή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />3<br /><input class="form-control" type="radio" name="katast_dermatos" value="3"'.($row['katast_dermatos']==3 ? 'checked="checked"' : '').'/></td>
      <td>Ελαφρώς κυρτός, λαμπερός, ελαφρώς<br />αδιαφανής, κόρη μαύρη, θαμπή.</td>
        <td>Βαθ.<br />3<br /><input class="form-control" type="radio" name="katast_ofthalmou" value="3"'.($row['katast_ofthalmou']==3 ? 'checked="checked"' : '').'/></td>
      <td>Ρόδινα, ελαφρώς αποχρωματισμένα,<br /> με διαυγή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />3<br /><input class="form-control" type="radio" name="katast_bragxiwn" value="3"'.($row['katast_bragxiwn']==3 ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Αποχρωματισμένο & θαμπό με<br />θολή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />2<br /><input class="form-control" type="radio" name="katast_dermatos" value="2"'.($row['katast_dermatos']==2 ? 'checked="checked"' : '').'/></td>
      <td>Επίπεδος, αδιαφανής, κόρη διαφανής.</td>
      <td>Βαθ.<br />2<br /><input class="form-control" type="radio" name="katast_ofthalmou" value="2"'.($row['katast_ofthalmou']==2 ? 'checked="checked"' : '').'/></td>
      <td>Αποχρωματισμένα με ελαφρώς θολή<br />γλοιώδης ουσία.</td>
      <td>Βαθ.<br />2<br /><input class="form-control" type="radio" name="katast_bragxiwn" value="2"'.($row['katast_bragxiwn']==2 ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Χρώμα θαμπό με αδιαφανή<br />γλοιώδης ουσία.</td>
      <td>Βαθ.<br />1<br /><input class="form-control" type="radio" name="katast_dermatos" value="1"'.($row['katast_dermatos']==1 ? 'checked="checked"' : '').'/></td>
      <td>Κοίλος εις το μέσον, γαλακτόχρους<br />κόρη γκρίζα.</td>
      <td>Βαθ.<br />1<br /><input class="form-control" type="radio" name="katast_ofthalmou" value="1"'.($row['katast_ofthalmou']==1 ? 'checked="checked"' : '').'/></td>
      <td>Κιτρινωπά, καφέ, με θολή<br />γαλακτόχρους γλοιώδης ουσία</td>
      <td>Βαθ.<br />1<br /><input class="form-control" type="radio" name="katast_bragxiwn" value="1"'.($row['katast_bragxiwn']==1 ? 'checked="checked"' : '').'/></td>
    </tr>
  </table>
    <table border="1" style="float:right;" class="table table-bordered table-condensed  table-responsive">
    <tr>
      <th>Βαθμοί</th> <th>Χαρακτηρισμός</th>
    </tr>
    <tr class="'.($row['freskothta']=='EXTRA' ? 'blue' : '' ).'" >
      <td>10 - 12</td> <td>EXTRA</td>
    </tr>
    <tr class="'.($row['freskothta']=='A' ? 'green' : '' ).'" >
      <td>7 - 9</td> <td>A</td>
    </tr>
    <tr class="'.($row['freskothta']=='B' ? 'orange' : '' ).'" >
      <td>4 - 6</td> <td>B</td>
    </tr>
    <tr class="'.($row['freskothta']=='REJECTED' ? 'red' : '' ).'" >
      <td><4</td> <td>Απορριπτέο</td>
    </tr>
  </table>
  <div id="general">
  <center><b>Γενικά</b></center>
  <table style="float:left;" border="1" class="table table-striped table-bordered table-condensed  table-responsive">
    <tr>
      <th>Κατάσταση Σάρκας</th> <th></th> <th>Χρώμα</th> <th></th> <th>Απολέπιση</th> <th></th> <th>Αιματώματα</th> <th></th> <th>Κοιλιά</th>
    </tr>
    <tr>
      <td>Λεία & Υγρή <input class="form-control" type="radio" name="stat_sarkas" value="Λεία & Υγρή" '.($row['stat_sarkas']=='Λεία & Υγρή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Ιριδίζον <input class="form-control" type="radio" name="stat_xrwma" value="Ιριδίζον" '.($row['stat_xrwma']=='Ιριδίζον' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Ελαφρή <input class="form-control" type="radio" name="stat_apolepish" value="Ελαφρή" '.($row['stat_apolepish']=='Ελαφρή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Κεφαλή <input class="form-control" type="radio" name="stat_aimatwmata" value="Κεφαλή" '.($row['stat_aimatwmata']=='Κεφαλή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Κυλινδρική <input class="form-control" type="radio" name="stat_koilia" value="Κυλινδρική" '.($row['stat_koilia']=='Κυλινδρική' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κέρινη <input class="form-control" type="radio" name="stat_sarkas" value="Κέρινη" '.($row['stat_sarkas']=='Κέρινη' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Ζωηρό <input class="form-control" type="radio" name="stat_xrwma" value="Ζωηρό" '.($row['stat_xrwma']=='Ζωηρό' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Μεσαία <input class="form-control" type="radio" name="stat_apolepish" value="Μεσαία" '.($row['stat_apolepish']=='Μεσαία' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Σώμα <input class="form-control" type="radio" name="stat_aimatwmata" value="Σώμα" '.($row['stat_aimatwmata']=='Σώμα' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Διογκωμένη <input class="form-control" type="radio" name="stat_koilia" value="Διογκωμένη" '.($row['stat_koilia']=='Διογκωμένη' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Στεγνή <input class="form-control" type="radio" name="stat_sarkas" value="Στεγνή" '.($row['stat_sarkas']=='Στεγνή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Θαμπό <input class="form-control" type="radio" name="stat_xrwma" value="Θαμπό" '.($row['stat_xrwma']=='Θαμπό' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Έντονη <input class="form-control" type="radio" name="stat_apolepish" value="Έντονη" '.($row['stat_apolepish']=='Έντονη' ? 'checked="checked"' : '').'/></td>  <td></td>
      <td>Περιοχές <input class="form-control" type="radio" name="stat_aimatwmata" value="Περιοχές" '.($row['stat_aimatwmata']=='Περιοχές' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Μαλακή <input class="form-control" type="radio" name="stat_koilia" value="Μαλακή" '.($row['stat_koilia']=='Μαλακή' ? 'checked="checked"' : '').'/></td>
    </tr>
  </table>
  </div>

    <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
    <tr>
      <th></th> <th>Τυπική</th> <th>Προβληματική</th> <th>Μη Αποδεκτή</th> <th>Διόρθωση</th>
    </tr>
    <tr>
      <td>Κουρμπάρισμα</td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Τυπική" '.($row['susk_kourmparisma']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Προβληματική" '.($row['susk_kourmparisma']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Μη Αποδεκτή" '.($row['susk_kourmparisma']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Διόρθωση" '.($row['susk_kourmparisma']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Φελιζόλ</td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Τυπική" '.($row['susk_felizol']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Προβληματική" '.($row['susk_felizol']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Μη Αποδεκτή" '.($row['susk_felizol']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Διόρθωση" '.($row['susk_felizol']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Πάγου</td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Τυπική" '.($row['susk_pagos']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Προβληματική" '.($row['susk_pagos']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Μη Αποδεκτή" '.($row['susk_pagos']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Διόρθωση" '.($row['susk_pagos']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Παλέτας</td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Τυπική" '.($row['susk_paleta']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Προβληματική" '.($row['susk_paleta']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Μη Αποδεκτή" '.($row['susk_paleta']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Διόρθωση" '.($row['susk_paleta']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Σήμανσης</td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Τυπική" '.($row['susk_shmansh']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Προβληματική" '.($row['susk_shmansh']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Μη Αποδεκτή" '.($row['susk_shmansh']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Διόρθωση" '.($row['susk_shmansh']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
  </table>

  <br />
  <div>
  <p><b>ΠΑΡΑΤΗΡΗΣΕΙΣ: Οι θερμογράφοι να είναι σε ετοιμότητα 24ωρης εγγραφής!!! <br />Σύντομη Περιγραφή του Δείγματος</b></p>
  <textarea name="comment" style="height:200px;width:400px;">'.$row['parathrhseis'].'</textarea>
  <br />
  <!-- <input class="form-control" type="submit" name="submit" value="Καταχώρηση" style="height:100px;width:200px;" /> -->
  </div>
</div>

</form>';
  $pics = json_decode($row['picture']);
  if(sizeof($pics)>0){
    echo "<div class='panel panel-default'>
    				<div class='panel-heading'>
    					Φωτογραφίες
    				</div>
    				<div class='panel-body'>";
     $ii=1;
  echo "<div id='pics'><div class'row'>";
  foreach($pics as $pic){
  try{
    $resize = new ResizeImage('uploads/images/'.$pic);
    $resize->resizeTo(300, 300, 'maxHeight');
    $resize->saveImage('uploads/images/temp/'.$pic);
    echo "<div class='col-sm-".(12/sizeof($pics))."'><center><img class='img-responsive' height=\"300\" onclick=\"zoom('".$pic."');\" src=\"uploads/images/temp/".$pic."\" /></center></div>";
  } catch (Exception $e) {
    // echo 'Caught exception: ',  $e->getMessage(), "\n";
  }

    if($ii%4==0){
      echo "</div><div class='row'>";
    }
    $ii++;
  }
  echo "</div></div></div>";
  }

  echo "</div>";
} elseif(isset($_GET['type']) && $_GET['type']=='viewall'){
  if(isset($_GET['sort']) && $_GET['sort']=='today'){
    $qry = "SELECT id, hm_elegxou, etairia, elegkths, eidos,megethos, monada_paxunshs,flag, picture FROM control_form2 WHERE isactive=1 AND hm_elegxou='".date('Y-m-d')."' ORDER BY id DESC";
  } elseif($_SESSION['susername']=='sel' || $_SESSION['susername']=='maroudas') {
    $qry = "SELECT id, hm_elegxou, etairia, elegkths, eidos,megethos, monada_paxunshs,flag, picture FROM control_form2 WHERE isactive=1 AND etairia='ΣΕΛΟΝΤΑ' ORDER BY id DESC";
  } else {
      $qry = "SELECT id, hm_elegxou, etairia, elegkths, eidos,megethos, monada_paxunshs,flag, picture FROM control_form2 WHERE isactive=1 ORDER BY id DESC";
  }

  $res = mysqli_query($dbC,$qry);
 ?>
    <style>
        #viewall_filter{
            float:left;
        }
        #viewall_filter>label{
            font-weight:800;
        }
        #viewall_length{
            float:right;
        }
        .qcontrols tr td:hover {
          cursor: pointer;
        }

        .qcontrols tr th {
          background-color: #414141 !important;
          color: rgb(217, 181, 31) !important;
        }

        .qcontrols td,
        .qcontrols th {
          text-align: center;
        }

      </style>
      <a href="control.php?type=viewall&sort=today" class="btn btn-default">Σημερινές Εγγραφές</a>
      <div id="container">
        <table id="viewall" class="table table-bordered table-responsive table-condensed table-hover datatable">
          <thead>
          <tr>
            <th>ID</th>
            <th>Εταιρία</th>
            <th>Ελεγκτής</th>
            <th>Είδος</th>
            <th>Μονάδα Πάχυνσης</th>
            <th>Ημ. Ελέγχου</th>
            <th>Έχει φωτογραφίες</th>
            <th>Επεξεργασία</th>
          </tr>
          </thead>
          <tbody>
          <?php
    while($row=mysqli_fetch_array($res)){
      echo "<tr class=\"".($row['flag']==1 ? 'blue' : '')."\">
      <td>".$row['id']."</td>
      <td>".$row['etairia']."</td>
      <td>".$row['elegkths']."</td>
      <td>".$row['eidos'].$row['megethos']."</td>
      <td>".$row['monada_paxunshs']."</td>
      <td>".date('d-m-Y',strtotime($row['hm_elegxou']))."</td>
      <td>".(empty($row['picture']) ? '' : '<img src="img/img.png" height="25px" />')."</td>
      <td>
      <div class='btn-group'>
      <button class='btn btn-default' onclick=\"document.location = 'control2.php?type=view&id=".$row['id']."';\">View</button> ";
      echo "</div></td></tr>";
    }

   ?>
          </tbody>
        </table>
      </div>

      <?php
} elseif(isset($_GET['type']) && $_GET['type']=='edit'){
  $qry = "SELECT * FROM control_form WHERE id=".$_GET['id'];
  $res = mysqli_query($dbC, $qry);
  $row = mysqli_fetch_array($res);
  $sn_kiv = json_decode($row['sn_kib'],1);
  $posothta_pagou = json_decode($row['posothta_pagou'],1);
  $pagos_kg = json_decode($row['pagos_kg'],1);
  $therm_kiv = json_decode($row['therm_kiv'],1);
  $therm_psariwn = json_decode($row['therm_psariwn'],1);
  $ar_psariwn = json_decode($row['ar_psariwn'],1);
  $varos_kiv = json_decode($row['varos_kiv'],1);
  $kefalh = json_decode($row['kefalh'],1);
  $koilia = json_decode($row['koilia'],1);
  $swma = json_decode($row['swma'],1);
  $bragxia = json_decode($row['bragxia'],1);
  $matia = json_decode($row['matia'],1);
  $dusmorfies = json_decode($row['dusmorfies'],1);
  $apobolh_trofhs = json_decode($row['apobolh_trofhs'],1);
  $alloiwseis = json_decode($row['alloiwseis'],1);
  $parasita = json_decode($row['parasita'],1);
  $upomege8h = json_decode($row['upomege8h'],1);
  $upermege8h = json_decode($row['upermege8h'],1);
  $pinpar = json_decode($row['pinakas_par']);
  $pinsum = json_decode($row['pinsum']);

echo '<div id="main_wrap"><form name="control_form" action="control_parse.php?type=edit&id='.$row['id'].'" method="POST">
<input type="hidden" value="'.$row['id'].'" name="form_id" />
<div id="head" style="width:100%;text-align:center;">
<table border="1" style="width:100%;text-align:center;" class="table table-striped table-bordered table-condensed  table-responsive">
<tbody>
  <tr>
    <th colspan="4">Ημ/νία Παραλαβής</th>
  </tr>
  <tr>
    <td colspan="4">'.($row['hm_paralav']!='-' ? '<input type="date" class="form-control hmfrm" name="hm_paralav" value="'.date('Y-m-d',strtotime($row['hm_paralav'])).'" />' : '<input type="text" class="form-control hmfrm" name="hm_paralav" value="'.$row['hm_paralav'].'" />').'Χωρίς ημερομηνία&nbsp<input type="checkbox" class="incheck" name="hm_paralav2" value="-"/></td>
  </tr>
  <tr>
        <th>Εταιρία</th>
        <th>Μονάδα Πάχυνσης</th>
        <th colspan="2">Συσκευαστήριο</th>

  </tr>
  <tr>
        <td><input class="form-control" name="etairia" type="text" value="'.$row['etairia'].'" /></td>
        <td><input class="form-control" name="monada_paxunshs" type="text" value="'.$row['monada_paxunshs'].'" /></td>
        <td colspan="2"><input class="form-control" name="kwd_sus" type="text" value="'.$row['kwd_sus'].'" /></td>

  </tr>
  <tr>
        <th>Ετικετέζα</th>
        <th>Μετατόπιση</th>
        <th colspan="2">Ελεγκτής</th>
  </tr>
  <tr>
        <td><input class="form-control" name="etiketeza" type="text" value="'.$row['etiketeza'].'" /></td>
    <td><input class="form-control" name="metatopish" type="text" value="'.$row['metatopish'].'" /></td>
        <td colspan="2"><input class="form-control" name="elegkths" type="text" value="'.$row['elegkths'].'" /></td>
  </tr>
  <tr>
        <th>Ημ/νία Ελέγχου</th>
        <th>Ώρα Ελέγχου</th>
        <th colspan="2">Ημερομηνία Λήξης - Παραγωγής</th>
  </tr>
  <tr>
        <td><input class="form-control" name="hm_elegxou" type="date" value="'.date('Y-m-d',strtotime($row['hm_elegxou'])).'" /></td>
        <td><input class="form-control" name="wra_elegxou" type="time" value="'.$row['wra_elegxou'].'" /></td>
        <td colspan="2"><input class="form-control hmfrm" name="hm_lixpar" type="date" value="'.date('Y-m-d',strtotime($row['hm_lixpar'])).'" />Καμία Ημ/νία&nbsp<input type="checkbox" name="no_lixpar" class="incheck"/></td>
  </tr>
  <tr>
    <th>Είδος/Μέγεθος</th>
    <th>Κιβώτιο</th>
    <th>Είδος Κιβωτίου</th>
    <th>Παρτίδα</th>
  </tr>
  <tr>
    <td>
    <div class="row">
      <div class="col-sm-6">
        <select class="form-control" name="eidos">
           <option '.($row['eidos']=="Λ" ? "selected" : "").'>Λ</option>
           <option '.($row['eidos']=="Τ" ? "selected" : "").'>Τ</option>
           <option '.($row['eidos']=="Άλλο" ? "selected" : "").'>Άλλο</option>
        </select>
      </div>
      <div class="col-sm-6">
        <select class="form-control" name="megethos">
           <option '.($row['megethos']=="2/3" ? "selected" : "").'>2/3</option>
           <option '.($row['megethos']=="3/4" ? "selected" : "").'>3/4</option>
           <option '.($row['megethos']=="4/6" ? "selected" : "").'>4/6</option>
           <option '.($row['megethos']=="6/8" ? "selected" : "").'>6/8</option>
           <option '.($row['megethos']=="8/1000" ? "selected" : "").'>8/1000</option>
           <option '.($row['megethos']=="1000+" ? "selected" : "").'>1000+</option>
           <option '.($row['megethos']=="1500+" ? "selected" : "").'>1500+</option>
           <option '.($row['megethos']=="Άλλο" ? "selected" : "").'>Άλλο</option>
        </select>
      </div>
    </div>
    </td>
    <td><ul id="varos_kiv2">
                  <li>10 <input class="form-control" type="radio" name="varos_kiv2" value="10" '.($row['varos_kiv2']==10 ? 'checked' : '').'/></li>
                  <li>6 <input class="form-control" type="radio" name="varos_kiv2" value="6" '.($row['varos_kiv2']==6 ? 'checked' : '').'/></li>
                  <li>3 <input class="form-control" type="radio" name="varos_kiv2" value="3" '.($row['varos_kiv2']==3 ? 'checked' : '').'/></li>
                </ul></td>
    <td><input class="form-control" name="eidos_kiv" type="text" value="'.$row['eidos_kiv'].'" /></td>
    <td><input class="form-control" name="partida" type="text" value="'.$row['partida'].'" /></td>

  </tr>
</tbody>
</table>
</div>';

?>

<div class="panel panel-default">
   <div class="panel-heading" id="toggle_partbl" style="cursor:pointer;">Πίνακας Παραγωγής <span class="pull-right"><i id="toggle_partbl2" class="glyphicon glyphicon-plus"></i></span></div>
   <div class="panel-body" style="display: none;" id="partbl_body">
      <table class="table table-striped table-responsive table-bordered">
         <thead>
            <tr>
               <th></th>
               <th>Κιβώτιο 1</th>
               <th>Κιβώτιο 2</th>
               <th>Κιβώτιο 3</th>
               <th>Κιβώτιο 4</th>
            </tr>
         </thead>
         <tbody>
            <?php
               for($y=1;$y<=40;$y++){
                  echo
                  "<tr>
                     <td>".$y."</td>
                     <td><center><input class=\"form-control\" data-order=\"1\" type='number' value='".$pinpar[0][$y-1]."' name='par_kiv1[]' /></center></td>
                     <td><center><input class=\"form-control\" data-order=\"2\" type='number' value='".$pinpar[1][$y-1]."' name='par_kiv2[]' /></center></td>
                     <td><center><input class=\"form-control\" data-order=\"3\" type='number' value='".$pinpar[2][$y-1]."' name='par_kiv3[]' /></center></td>
                     <td><center><input class=\"form-control\" data-order=\"4\" type='number' value='".$pinpar[3][$y-1]."' name='par_kiv4[]' /></center></td>
                  </tr>";
               }
            ?>
         </tbody>
         <tfoot>
           <tr>
             <td>sum</td>
             <td id="athr1"><center><input class="form-control" name="pinsum[]" value="<?php echo $pinsum[0]; ?>" type="number" /></center></td>
             <td id="athr2"><center><input class="form-control" name="pinsum[]" value="<?php echo $pinsum[1]; ?>" type="number" /></center></td>
             <td id="athr3"><center><input class="form-control" name="pinsum[]" value="<?php echo $pinsum[2]; ?>" type="number" /></center></td>
             <td id="athr4"><center><input class="form-control" name="pinsum[]" value="<?php echo $pinsum[3]; ?>" type="number" /></center></td>
           </tr>
         </tfoot>
      </table>
   </div>
</div>

<?php

echo '<div id="left_col">
<table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
  <tr>
    <th></th><th>Κιβ. 1</th><th>Κιβ. 2</th><th>Κιβ. 3</th>
  </tr>
  <tr>
    <th>S/N Κιβωτίου</th><td><input class="form-control" name="sn_kib[]" type="text" value="'.$sn_kiv[0].'" /></td><td><input class="form-control" name="sn_kib[]" type="text" value="'.$sn_kiv[1].'" /></td>
        <td><input class="form-control" name="sn_kib[]" type="text" value="'.$sn_kiv[2].'" /></td>
        <td><input class="form-control" name="sn_kib[]" type="text" value="'.$sn_kiv[3].'" /></td>
  </tr>
  <tr>
    <th>Ποσότητα Πάγου %</th><td><input class="form-control" step="0.001" name="posothta_pagou[]" type="number" value="'.$posothta_pagou[0].'" /></td><td><input class="form-control" step="0.001" name="posothta_pagou[]" type="number" value="'.$posothta_pagou[1].'" /></td>
        <td><input class="form-control" step="0.01" name="posothta_pagou[]" type="number" value="'.$posothta_pagou[2].'" /></td>
        <td><input class="form-control" step="0.01" name="posothta_pagou[]" type="number" value="'.$posothta_pagou[3].'" /></td>
  </tr>
  <tr>
    <th>Ποσότητα Πάγου σε Kg</th><td><input class="form-control" step="0.001" name="pagos_kg[]" type="number" value="'.$pagos_kg[0].'" /></td><td><input class="form-control" step="0.001" name="pagos_kg[]" type="number" value="'.$pagos_kg[1].'" /></td>
        <td><input class="form-control" name="pagos_kg[]" step="0.001" type="number" value="'.$pagos_kg[2].'" /></td>
        <td><input class="form-control" name="pagos_kg[]" step="0.001" type="number" value="'.$pagos_kg[3].'" /></td>
  </tr>
  <tr>
    <th>Θερμοκρασία Κιβωτίου</th><td><input class="form-control" step="0.001" name="therm_kiv[]" type="number" value="'.$therm_kiv[0].'" /></td><td><input class="form-control" step="0.001" name="therm_kiv[]" type="number" value="'.$therm_kiv[1].'" /></td>
        <td><input class="form-control" step="0.001" name="therm_kiv[]" type="number" value="'.$therm_kiv[2].'" /></td>
        <td><input class="form-control" step="0.001" name="therm_kiv[]" type="number" value="'.$therm_kiv[3].'" /></td>
  </tr>
  <tr>
    <th>Θερμοκρασία Ψαριού</th><td><input class="form-control" step="0.001" name="therm_psariwn[]" type="number" value="'.$therm_psariwn[0].'" /></td><td><input class="form-control" step="0.001" name="therm_psariwn[]" type="number" value="'.$therm_psariwn[1].'" /></td>
        <td><input class="form-control" step="0.001" name="therm_psariwn[]" type="number" value="'.$therm_psariwn[2].'" /></td>
        <td><input class="form-control" step="0.001" name="therm_psariwn[]" type="number" value="'.$therm_psariwn[3].'" /></td>
  </tr>
  <tr>
    <th>Αριθμός Ψαριών</th><td><input class="form-control" name="ar_psariwn[]" type="number" value="'.$ar_psariwn[0].'" /></td><td><input class="form-control" name="ar_psariwn[]" type="number" value="'.$ar_psariwn[1].'" /></td>
        <td><input class="form-control" name="ar_psariwn[]" type="number" value="'.$ar_psariwn[2].'" /></td>
        <td><input class="form-control" name="ar_psariwn[]" type="number" value="'.$ar_psariwn[3].'" /></td>
  </tr>
  <tr>
    <th>Βάρος Κιβωτίου</th><td><input class="form-control" step="0.001" name="varos_kiv[]" type="number" value="'.$varos_kiv[0].'" /></td><td><input class="form-control" step="0.001" name="varos_kiv[]" type="number" value="'.$varos_kiv[1].'" /></td>
        <td><input class="form-control" step="0.001" name="varos_kiv[]" type="number" value="'.$varos_kiv[2].'" /></td>
        <td><input class="form-control" step="0.001" name="varos_kiv[]" type="number" value="'.$varos_kiv[3].'" /></td>
  </tr>
  <tr>
    <th>Αποβολή Τροφής</th>
    <td><input class="form-control" name="apobolh_trofhs[]" type="number" value="'.$apobolh_trofhs[0].'" /></td>
    <td><input class="form-control" name="apobolh_trofhs[]" type="number" value="'.$apobolh_trofhs[1].'" /></td>
    <td><input class="form-control" name="apobolh_trofhs[]" type="number" value="'.$apobolh_trofhs[2].'" /></td>
    <td><input class="form-control" name="apobolh_trofhs[]" type="number" value="'.$apobolh_trofhs[3].'" /></td>
  </tr>
  <tr>
    <th>Υπομεγέθη</th>
    <td><input class="form-control" name="upomege8h[]" type="number" value="'.$upomege8h[0].'" /></td>
    <td><input class="form-control" name="upomege8h[]" type="number" value="'.$upomege8h[1].'" /></td>
    <td><input class="form-control" name="upomege8h[]" type="number" value="'.$upomege8h[2].'" /></td>
    <td><input class="form-control" name="upomege8h[]" type="number" value="'.$upomege8h[3].'" /></td>
  </tr>
  <tr>
    <th>Υπερμεγέθη</th>
    <td><input class="form-control" name="upermege8h[]" type="number" value="'.$upermege8h[0].'" /></td>
    <td><input class="form-control" name="upermege8h[]" type="number" value="'.$upermege8h[1].'" /></td>
    <td><input class="form-control" name="upermege8h[]" type="number" value="'.$upermege8h[2].'" /></td>
    <td><input class="form-control" name="upermege8h[]" type="number" value="'.$upermege8h[3].'" /></td>
  </tr>
  <tr><th>Αιματώματα</th><td colspan="4">
    <table border="0" class="table table-striped table-bordered table-condensed  table-responsive">
      <tr>
        <th>Κεφαλή</th>
        <td>
          <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
          <tr>
            <th>Ελαφρά</th>
            <td><input class="form-control" name="kefalh_elafra[]" type="number" value="'.$kefalh['elafra'][0].'" /></td>
            <td><input class="form-control" name="kefalh_elafra[]" type="number" value="'.$kefalh['elafra'][1].'" /></td>
            <td><input class="form-control" name="kefalh_elafra[]" type="number" value="'.$kefalh['elafra'][2].'" /></td>
            <td><input class="form-control" name="kefalh_elafra[]" type="number" value="'.$kefalh['elafra'][3].'" /></td>
          </tr>
          <tr>
            <th>Μεσαία</th>
            <td><input class="form-control" name="kefalh_mesaia[]" type="number" value="'.$kefalh['mesaia'][0].'" /></td>
            <td><input class="form-control" name="kefalh_mesaia[]" type="number" value="'.$kefalh['mesaia'][1].'" /></td>
            <td><input class="form-control" name="kefalh_mesaia[]" type="number" value="'.$kefalh['mesaia'][2].'" /></td>
            <td><input class="form-control" name="kefalh_mesaia[]" type="number" value="'.$kefalh['mesaia'][3].'" /></td>
          </tr>
          <tr>
            <th>Έντονα</th>
            <td><input class="form-control" name="kefalh_entona[]" type="number" value="'.$kefalh['entona'][0].'" /></td>
            <td><input class="form-control" name="kefalh_entona[]" type="number" value="'.$kefalh['entona'][1].'" /></td>
            <td><input class="form-control" name="kefalh_entona[]" type="number" value="'.$kefalh['entona'][2].'" /></td>
            <td><input class="form-control" name="kefalh_entona[]" type="number" value="'.$kefalh['entona'][3].'" /></td>
          </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Κοιλιά</th>
        <td>
          <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
          <tr>
            <th>Κηλίδες</th>
            <td><input class="form-control" name="koilia_khlides[]" type="number" value="'.$koilia['khlides'][0].'" /></td>
            <td><input class="form-control" name="koilia_khlides[]" type="number" value="'.$koilia['khlides'][1].'" /></td>
            <td><input class="form-control" name="koilia_khlides[]" type="number" value="'.$koilia['khlides'][2].'" /></td>
            <td><input class="form-control" name="koilia_khlides[]" type="number" value="'.$koilia['khlides'][3].'" /></td>
          </tr>
          <tr>
            <th>Στικτά</th>
            <td><input class="form-control" name="koilia_stikta[]" type="number" value="'.$koilia['stikta'][0].'" /></td>
            <td><input class="form-control" name="koilia_stikta[]" type="number" value="'.$koilia['stikta'][1].'" /></td>
            <td><input class="form-control" name="koilia_stikta[]" type="number" value="'.$koilia['stikta'][2].'" /></td>
            <td><input class="form-control" name="koilia_stikta[]" type="number" value="'.$koilia['stikta'][3].'" /></td>
          </tr>
          <tr>
            <th>Διάχυτα</th>
            <td><input class="form-control" name="koilia_diaxuta[]" type="number" value="'.$koilia['diaxuta'][0].'" /></td>
            <td><input class="form-control" name="koilia_diaxuta[]" type="number" value="'.$koilia['diaxuta'][1].'" /></td>
            <td><input class="form-control" name="koilia_diaxuta[]" type="number" value="'.$koilia['diaxuta'][2].'" /></td>
            <td><input class="form-control" name="koilia_diaxuta[]" type="number" value="'.$koilia['diaxuta'][3].'" /></td>
          </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Σώμα</th>
        <td>
          <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
          <tr>
            <th>Κηλίδες</th>
            <td><input class="form-control" name="swma_khlides[]" type="number" value="'.$swma['khlides'][0].'" /></td>
            <td><input class="form-control" name="swma_khlides[]" type="number" value="'.$swma['khlides'][1].'" /></td>
            <td><input class="form-control" name="swma_khlides[]" type="number" value="'.$swma['khlides'][2].'" /></td>
            <td><input class="form-control" name="swma_khlides[]" type="number" value="'.$swma['khlides'][3].'" /></td>
          </tr>
          <tr>
            <th>Στικτά</th>
            <td><input class="form-control" name="swma_stikta[]" type="number" value="'.$swma['stikta'][0].'" /></td>
            <td><input class="form-control" name="swma_stikta[]" type="number" value="'.$swma['stikta'][1].'" /></td>
            <td><input class="form-control" name="swma_stikta[]" type="number" value="'.$swma['stikta'][2].'" /></td>
            <td><input class="form-control" name="swma_stikta[]" type="number" value="'.$swma['stikta'][3].'" /></td>
          </tr>
          <tr>
            <th>Διάχυτα</th>
            <td><input class="form-control" name="swma_diaxuta[]" type="number" value="'.$swma['diaxuta'][0].'" /></td>
            <td><input class="form-control" name="swma_diaxuta[]" type="number" value="'.$swma['diaxuta'][1].'" /></td>
            <td><input class="form-control" name="swma_diaxuta[]" type="number" value="'.$swma['diaxuta'][2].'" /></td>
            <td><input class="form-control" name="swma_diaxuta[]" type="number" value="'.$swma['diaxuta'][3].'" /></td>
          </tr>
          </table>
        </td>
      </tr>

    </table>
    </td>
  </tr>
  <tr>
    <th>Βράγχια</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Ρόδινα</th>
          <td><input class="form-control" name="vragxia_rodina[]" type="number" value="'.$bragxia['rodina'][0].'" /></td>
          <td><input class="form-control" name="vragxia_rodina[]" type="number" value="'.$bragxia['rodina'][1].'" /></td>
          <td><input class="form-control" name="vragxia_rodina[]" type="number" value="'.$bragxia['rodina'][2].'" /></td>
          <td><input class="form-control" name="vragxia_rodina[]" type="number" value="'.$bragxia['rodina'][3].'" /></td>
        </tr>
        <tr>
          <th>Φαιά</th>
          <td><input class="form-control" name="vragxia_faia[]" type="number" value="'.$bragxia['faia'][0].'" /></td>
          <td><input class="form-control" name="vragxia_faia[]" type="number" value="'.$bragxia['faia'][1].'" /></td>
          <td><input class="form-control" name="vragxia_faia[]" type="number" value="'.$bragxia['faia'][2].'" /></td>
          <td><input class="form-control" name="vragxia_faia[]" type="number" value="'.$bragxia['faia'][3].'" /></td>
        </tr>
        <tr>
          <th>Μ.Ε.Β.Ν.</th>
          <td><input class="form-control" name="vragxia_mebn[]" type="number" value="'.$bragxia['mebn'][0].'" /></td>
          <td><input class="form-control" name="vragxia_mebn[]" type="number" value="'.$bragxia['mebn'][1].'" /></td>
          <td><input class="form-control" name="vragxia_mebn[]" type="number" value="'.$bragxia['mebn'][2].'" /></td>
          <td><input class="form-control" name="vragxia_mebn[]" type="number" value="'.$bragxia['mebn'][3].'" /></td>
        </tr>
        <tr>
          <th>Αιματώματα</th>
          <td><input class="form-control" name="vragxia_aimat[]" type="number" value="'.$bragxia['aimatwmata'][0].'" /></td>
          <td><input class="form-control" name="vragxia_aimat[]" type="number" value="'.$bragxia['aimatwmata'][1].'" /></td>
          <td><input class="form-control" name="vragxia_aimat[]" type="number" value="'.$bragxia['aimatwmata'][2].'" /></td>
          <td><input class="form-control" name="vragxia_aimat[]" type="number" value="'.$bragxia['aimatwmata'][3].'" /></td>
        </tr>
        <tr>
          <th>Καφέ</th>
          <td><input class="form-control" name="vragxia_kafe[]" type="number" value="'.$bragxia['kafe'][0].'" /></td>
          <td><input class="form-control" name="vragxia_kafe[]" type="number" value="'.$bragxia['kafe'][1].'" /></td>
          <td><input class="form-control" name="vragxia_kafe[]" type="number" value="'.$bragxia['kafe'][2].'" /></td>
          <td><input class="form-control" name="vragxia_kafe[]" type="number" value="'.$bragxia['kafe'][3].'" /></td>
        </tr>
        <tr>
          <th>Αποχρωματισμένα</th>
          <td><input class="form-control" name="vragxia_apoxr[]" type="number" value="'.$bragxia['apoxrwm'][0].'" /></td>
          <td><input class="form-control" name="vragxia_apoxr[]" type="number" value="'.$bragxia['apoxrwm'][1].'" /></td>
          <td><input class="form-control" name="vragxia_apoxr[]" type="number" value="'.$bragxia['apoxrwm'][2].'" /></td>
          <td><input class="form-control" name="vragxia_apoxr[]" type="number" value="'.$bragxia['apoxrwm'][3].'" /></td>
        </tr>
        <tr>
          <th>Βλέννα</th>
          <td><input class="form-control" name="vragxia_vlenna[]" type="number" value="'.$bragxia['vlenna'][0].'" /></td>
          <td><input class="form-control" name="vragxia_vlenna[]" type="number" value="'.$bragxia['vlenna'][1].'" /></td>
          <td><input class="form-control" name="vragxia_vlenna[]" type="number" value="'.$bragxia['vlenna'][2].'" /></td>
          <td><input class="form-control" name="vragxia_vlenna[]" type="number" value="'.$bragxia['vlenna'][3].'" /></td>
        </tr>
        <tr>
          <th>Αιματηρή Βλέννα</th>
          <td><input class="form-control" name="vragxia_aim_vlenn[]" type="number" value="'.$bragxia['aim_vlenna'][0].'" /></td>
          <td><input class="form-control" name="vragxia_aim_vlenn[]" type="number" value="'.$bragxia['aim_vlenna'][1].'" /></td>
          <td><input class="form-control" name="vragxia_aim_vlenn[]" type="number" value="'.$bragxia['aim_vlenna'][2].'" /></td>
          <td><input class="form-control" name="vragxia_aim_vlenn[]" type="number" value="'.$bragxia['aim_vlenna'][3].'" /></td>
        </tr>
      </table>

    </td>
  </tr>
  <tr>
    <th>Μάτια</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Λαμπερά</th>
          <td><input class="form-control" name="matia_lampera[]" type="number" value="'.$matia['lampera'][0].'" /></td>
          <td><input class="form-control" name="matia_lampera[]" type="number" value="'.$matia['lampera'][1].'" /></td>
          <td><input class="form-control" name="matia_lampera[]" type="number" value="'.$matia['lampera'][2].'" /></td>
          <td><input class="form-control" name="matia_lampera[]" type="number" value="'.$matia['lampera'][3].'" /></td>
        </tr>
        <tr>
          <th>Θολά</th>
                    <td><input class="form-control" name="matia_thola[]" type="number" value="'.$matia['thola'][0].'" /></td>
          <td><input class="form-control" name="matia_thola[]" type="number" value="'.$matia['thola'][1].'" /></td>
          <td><input class="form-control" name="matia_thola[]" type="number" value="'.$matia['thola'][2].'" /></td>
          <td><input class="form-control" name="matia_thola[]" type="number" value="'.$matia['thola'][3].'" /></td>
        </tr>
        <tr>
          <th>Λευκά</th>
                    <td><input class="form-control" name="matia_leuka[]" type="number" value="'.$matia['leuka'][0].'" /></td>
          <td><input class="form-control" name="matia_leuka[]" type="number" value="'.$matia['leuka'][1].'" /></td>
          <td><input class="form-control" name="matia_leuka[]" type="number" value="'.$matia['leuka'][2].'" /></td>
          <td><input class="form-control" name="matia_leuka[]" type="number" value="'.$matia['leuka'][3].'" /></td>
        </tr>
        <tr>
          <th>Επουλωμένα</th>
                    <td><input class="form-control" name="matia_epoulwmena[]" type="number" value="'.$matia['epoulwmena'][0].'" /></td>
          <td><input class="form-control" name="matia_epoulwmena[]" type="number" value="'.$matia['epoulwmena'][1].'" /></td>
          <td><input class="form-control" name="matia_epoulwmena[]" type="number" value="'.$matia['epoulwmena'][2].'" /></td>
          <td><input class="form-control" name="matia_epoulwmena[]" type="number" value="'.$matia['epoulwmena'][3].'" /></td>
        </tr>
        <tr>
          <th>Τυφλά</th>
                    <td><input class="form-control" name="matia_tufla[]" type="number" value="'.$matia['tufla'][0].'" /></td>
          <td><input class="form-control" name="matia_tufla[]" type="number" value="'.$matia['tufla'][1].'" /></td>
          <td><input class="form-control" name="matia_tufla[]" type="number" value="'.$matia['tufla'][2].'" /></td>
          <td><input class="form-control" name="matia_tufla[]" type="number" value="'.$matia['tufla'][3].'" /></td>
        </tr>
        <tr>
          <th>Αιμοραγικά</th>
                    <td><input class="form-control" name="matia_aimoragika[]" type="number" value="'.$matia['aimoragika'][0].'" /></td>
          <td><input class="form-control" name="matia_aimoragika[]" type="number" value="'.$matia['aimoragika'][1].'" /></td>
          <td><input class="form-control" name="matia_aimoragika[]" type="number" value="'.$matia['aimoragika'][2].'" /></td>
          <td><input class="form-control" name="matia_aimoragika[]" type="number" value="'.$matia['aimoragika'][3].'" /></td>
        </tr>
      </table>

    </td>
  </tr>
  <tr>
    <th>Δυσμορφίες</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Στραβό Στόμα</th>
          <td><input class="form-control" name="stravo_stoma[]" type="number" value="'.$dusmorfies['stravo_stoma'][0].'" /></td>
          <td><input class="form-control" name="stravo_stoma[]" type="number" value="'.$dusmorfies['stravo_stoma'][1].'" /></td>
          <td><input class="form-control" name="stravo_stoma[]" type="number" value="'.$dusmorfies['stravo_stoma'][2].'" /></td>
          <td><input class="form-control" name="stravo_stoma[]" type="number" value="'.$dusmorfies['stravo_stoma'][3].'" /></td>
        </tr>
        <tr>
          <th>Εξόγκωμα κάτω σιαγώνας</th>
                    <td><input class="form-control" name="eksogkoma_katw[]" type="number" value="'.$dusmorfies['eksogkoma_katw'][0].'" /></td>
          <td><input class="form-control" name="eksogkoma_katw[]" type="number" value="'.$dusmorfies['eksogkoma_katw'][1].'" /></td>
          <td><input class="form-control" name="eksogkoma_katw[]" type="number" value="'.$dusmorfies['eksogkoma_katw'][2].'" /></td>
          <td><input class="form-control" name="eksogkoma_katw[]" type="number" value="'.$dusmorfies['eksogkoma_katw'][3].'" /></td>
        </tr>
        <tr>
          <th>Προέκταση κάτω σιαγώνας</th>
                    <td><input class="form-control" name="eksogkoma_panw[]" type="number" value="'.$dusmorfies['proekt_katw'][0].'" /></td>
          <td><input class="form-control" name="eksogkoma_panw[]" type="number" value="'.$dusmorfies['proekt_katw'][1].'" /></td>
          <td><input class="form-control" name="eksogkoma_panw[]" type="number" value="'.$dusmorfies['proekt_katw'][2].'" /></td>
          <td><input class="form-control" name="eksogkoma_panw[]" type="number" value="'.$dusmorfies['proekt_katw'][3].'" /></td>
        </tr>
        <tr>
          <th>Παραμορφωμένο κεφάλι</th>
                    <td><input class="form-control" name="paramorf_kefali[]" type="number" value="'.$dusmorfies['paramorf_kefali'][0].'" /></td>
          <td><input class="form-control" name="paramorf_kefali[]" type="number" value="'.$dusmorfies['paramorf_kefali'][1].'" /></td>
          <td><input class="form-control" name="paramorf_kefali[]" type="number" value="'.$dusmorfies['paramorf_kefali'][2].'" /></td>
          <td><input class="form-control" name="paramorf_kefali[]" type="number" value="'.$dusmorfies['paramorf_kefali'][3].'" /></td>
        </tr>
        <tr>
          <th>Κάθετο εμπρός κεφάλι</th>
                    <td><input class="form-control" name="katheto_kefali[]" type="number" value="'.$dusmorfies['katheto_kefali'][0].'" /></td>
          <td><input class="form-control" name="katheto_kefali[]" type="number" value="'.$dusmorfies['katheto_kefali'][1].'" /></td>
          <td><input class="form-control" name="katheto_kefali[]" type="number" value="'.$dusmorfies['katheto_kefali'][2].'" /></td>
          <td><input class="form-control" name="katheto_kefali[]" type="number" value="'.$dusmorfies['katheto_kefali'][3].'" /></td>
        </tr>
        <tr>
          <th>Παπαγαλάκι</th>
                    <td><input class="form-control" name="papagalaki[]" type="number" value="'.$dusmorfies['papagalaki'][0].'" /></td>
          <td><input class="form-control" name="papagalaki[]" type="number" value="'.$dusmorfies['papagalaki'][1].'" /></td>
          <td><input class="form-control" name="papagalaki[]" type="number" value="'.$dusmorfies['papagalaki'][2].'" /></td>
          <td><input class="form-control" name="papagalaki[]" type="number" value="'.$dusmorfies['papagalaki'][3].'" /></td>
        </tr>
        <tr>
          <th>Μόνο Βραγχιοκάλυμμα</th>
                    <td><input class="form-control" name="vragxiokaluma[]" type="number" value="'.$dusmorfies['vragxiokaluma'][0].'" /></td>
          <td><input class="form-control" name="vragxiokaluma[]" type="number" value="'.$dusmorfies['vragxiokaluma'][1].'" /></td>
          <td><input class="form-control" name="vragxiokaluma[]" type="number" value="'.$dusmorfies['vragxiokaluma'][2].'" /></td>
          <td><input class="form-control" name="vragxiokaluma[]" type="number" value="'.$dusmorfies['vragxiokaluma'][3].'" /></td>
        </tr>
        <tr>
          <th>Ραχιτικά</th>
                    <td><input class="form-control" name="raxitika[]" type="number" value="'.$dusmorfies['raxitika'][0].'" /></td>
          <td><input class="form-control" name="raxitika[]" type="number" value="'.$dusmorfies['raxitika'][1].'" /></td>
          <td><input class="form-control" name="raxitika[]" type="number" value="'.$dusmorfies['raxitika'][2].'" /></td>
          <td><input class="form-control" name="raxitika[]" type="number" value="'.$dusmorfies['raxitika'][3].'" /></td>
        </tr>
        <tr>
          <th>Λόρδωση</th>
                    <td><input class="form-control" name="lordwsh[]" type="number" value="'.$dusmorfies['lordwsh'][0].'" /></td>
          <td><input class="form-control" name="lordwsh[]" type="number" value="'.$dusmorfies['lordwsh'][1].'" /></td>
          <td><input class="form-control" name="lordwsh[]" type="number" value="'.$dusmorfies['lordwsh'][2].'" /></td>
          <td><input class="form-control" name="lordwsh[]" type="number" value="'.$dusmorfies['lordwsh'][3].'" /></td>
        </tr>
        <tr>
          <th>Κοντόχοντρα</th>
                    <td><input class="form-control" name="kontoxontra[]" type="number" value="'.$dusmorfies['kontoxontra'][0].'" /></td>
          <td><input class="form-control" name="kontoxontra[]" type="number" value="'.$dusmorfies['kontoxontra'][1].'" /></td>
          <td><input class="form-control" name="kontoxontra[]" type="number" value="'.$dusmorfies['kontoxontra'][2].'" /></td>
          <td><input class="form-control" name="kontoxontra[]" type="number" value="'.$dusmorfies['kontoxontra'][3].'" /></td>
        </tr>
        <tr>
          <th>Κλίση ουράς</th>
                    <td><input class="form-control" name="klish_ouras[]" type="number" value="'.$dusmorfies['klish_ouras'][0].'" /></td>
          <td><input class="form-control" name="klish_ouras[]" type="number" value="'.$dusmorfies['klish_ouras'][1].'" /></td>
          <td><input class="form-control" name="klish_ouras[]" type="number" value="'.$dusmorfies['klish_ouras'][2].'" /></td>
          <td><input class="form-control" name="klish_ouras[]" type="number" value="'.$dusmorfies['klish_ouras'][3].'" /></td>
        </tr>
      </table>

    </td>
  </tr>
  <tr>
    <th>Αλλοιώσεις</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Φαγωμένες ουρές/πτερύγια</th>
                    <td><input class="form-control" name="fagwmenes_oures[]" type="number" value="'.$alloiwseis['fagwmenes_oures'][0].'" /></td>
          <td><input class="form-control" name="fagwmenes_oures[]" type="number" value="'.$alloiwseis['fagwmenes_oures'][1].'" /></td>
          <td><input class="form-control" name="fagwmenes_oures[]" type="number" value="'.$alloiwseis['fagwmenes_oures'][2].'" /></td>
          <td><input class="form-control" name="fagwmenes_oures[]" type="number" value="'.$alloiwseis['fagwmenes_oures'][3].'" /></td>
        </tr>
        <tr>
          <th>Πληγές & γδαρμένα</th>
                    <td><input class="form-control" name="plhges_gdarmena[]" type="number" value="'.$alloiwseis['plhges_gdarmena'][0].'" /></td>
          <td><input class="form-control" name="plhges_gdarmena[]" type="number" value="'.$alloiwseis['plhges_gdarmena'][1].'" /></td>
          <td><input class="form-control" name="plhges_gdarmena[]" type="number" value="'.$alloiwseis['plhges_gdarmena'][2].'" /></td>
          <td><input class="form-control" name="plhges_gdarmena[]" type="number" value="'.$alloiwseis['plhges_gdarmena'][3].'" /></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <th>Παράσιτα</th><td colspan="4">
      <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
        <tr>
          <th>Ψείρες</th>
                    <td><input class="form-control" name="pseires[]" type="number" value="'.$parasita['pseires'][0].'" /></td>
          <td><input class="form-control" name="pseires[]" type="number" value="'.$parasita['pseires'][1].'" /></td>
          <td><input class="form-control" name="pseires[]" type="number" value="'.$parasita['pseires'][2].'" /></td>
          <td><input class="form-control" name="pseires[]" type="number" value="'.$parasita['pseires'][3].'" /></td>
        </tr>
        <tr>
          <th>lernanthropus</th>
                    <td><input class="form-control" name="lamanthropus[]" type="number" value="'.$parasita['lamanthropus'][0].'" /></td>
          <td><input class="form-control" name="lamanthropus[]" type="number" value="'.$parasita['lamanthropus'][1].'" /></td>
          <td><input class="form-control" name="lamanthropus[]" type="number" value="'.$parasita['lamanthropus'][2].'" /></td>
          <td><input class="form-control" name="lamanthropus[]" type="number" value="'.$parasita['lamanthropus'][3].'" /></td>
        </tr>
      </table>
    </td>
  </tr>

</table>
</div>
<div id="right_col">
  <table border="1" style="text-align: center;" class="table table-striped table-bordered table-condensed  table-responsive">
    <tr>
      <th>Κατάσταση Δέρματος</th>
      <th></th>
      <th>Κατάσταση Οφθαλμού</th>
      <th></th>
      <th>Κατάσταση Βραγχίων</th>
      <th></th>
    </tr>
    <tr>
      <td>Ζωηρό ιριδίζον χρώμα, με υδαρή,<br />διαυγή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />4<br /><input class="form-control rating" type="radio" name="katast_dermatos" value="4" '.($row['katast_dermatos']==4 ? 'checked="checked"' : '').'/></td>
      <td>Κυρτός, διαυγής, κόρη μαύρη και<br />στίλβουσα.</td>
      <td>Βαθ.<br />4<br /><input class="form-control rating" type="radio" name="katast_ofthalmou" value="4" '.($row['katast_ofthalmou']==4 ? 'checked="checked"' : '').'/></td>
      <td>Στίλβοντα, ρόδινα, άνευ βλέννας</td>
      <td>Βαθ.<br />4<br /><input class="form-control rating" type="radio" name="katast_bragxiwn" value="4"'.($row['katast_bragxiwn']==4 ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Ζωηρό χρώμα χωρίς λάμψη με<br />ελαφρώς θολή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />3<br /><input class="form-control rating" type="radio" name="katast_dermatos" value="3"'.($row['katast_dermatos']==3 ? 'checked="checked"' : '').'/></td>
      <td>Ελαφρώς κυρτός, λαμπερός, ελαφρώς<br />αδιαφανής, κόρη μαύρη, θαμπή.</td>
        <td>Βαθ.<br />3<br /><input class="form-control rating" type="radio" name="katast_ofthalmou" value="3"'.($row['katast_ofthalmou']==3 ? 'checked="checked"' : '').'/></td>
      <td>Ρόδινα, ελαφρώς αποχρωματισμένα,<br /> με διαυγή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />3<br /><input class="form-control rating" type="radio" name="katast_bragxiwn" value="3"'.($row['katast_bragxiwn']==3 ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Αποχρωματισμένο & θαμπό με<br />θολή γλοιώδης ουσία.</td>
      <td>Βαθ.<br />2<br /><input class="form-control rating" type="radio" name="katast_dermatos" value="2"'.($row['katast_dermatos']==2 ? 'checked="checked"' : '').'/></td>
      <td>Επίπεδος, αδιαφανής, κόρη διαφανής.</td>
      <td>Βαθ.<br />2<br /><input class="form-control rating" type="radio" name="katast_ofthalmou" value="2"'.($row['katast_ofthalmou']==2 ? 'checked="checked"' : '').'/></td>
      <td>Αποχρωματισμένα με ελαφρώς θολή<br />γλοιώδης ουσία.</td>
      <td>Βαθ.<br />2<br /><input class="form-control rating" type="radio" name="katast_bragxiwn" value="2"'.($row['katast_bragxiwn']==2 ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Χρώμα θαμπό με αδιαφανή<br />γλοιώδης ουσία.</td>
      <td>Βαθ.<br />1<br /><input class="form-control rating" type="radio" name="katast_dermatos" value="1"'.($row['katast_dermatos']==1 ? 'checked="checked"' : '').'/></td>
      <td>Κοίλος εις το μέσον, γαλακτόχρους<br />κόρη γκρίζα.</td>
      <td>Βαθ.<br />1<br /><input class="form-control rating" type="radio" name="katast_ofthalmou" value="1"'.($row['katast_ofthalmou']==1 ? 'checked="checked"' : '').'/></td>
      <td>Κιτρινωπά, καφέ, με θολή<br />γαλακτόχρους γλοιώδης ουσία</td>
      <td>Βαθ.<br />1<br /><input class="form-control rating" type="radio" name="katast_bragxiwn" value="1"'.($row['katast_bragxiwn']==1 ? 'checked="checked"' : '').'/></td>
    </tr>
  </table>
    <table border="1" style="float:right;" class="table table-bordered table-condensed  table-responsive">
    <tr>
      <th>Βαθμοί</th> <th>Χαρακτηρισμός</th>
    </tr>
    <tr class="ratings '.($row['freskothta']=='EXTRA' ? 'blue' : '' ).'" >
      <td>10 - 12</td> <td>EXTRA</td>
    </tr>
    <tr class="ratings '.($row['freskothta']=='A' ? 'green' : '' ).'" >
      <td>7 - 9</td> <td>A</td>
    </tr>
    <tr class="ratings '.($row['freskothta']=='B' ? 'orange' : '' ).'" >
      <td>4 - 6</td> <td>B</td>
    </tr>
    <tr class="ratings '.($row['freskothta']=='REJECTED' ? 'red' : '' ).'" >
      <td><4</td> <td>Απορριπτέο</td>
    </tr>
  </table>
  <div id="general">
  <center><b>Γενικά</b></center>
  <table style="float:left;" border="1" class="table table-striped table-bordered table-condensed  table-responsive">
    <tr>
      <th>Κατάσταση Σάρκας</th> <th></th> <th>Χρώμα</th> <th></th> <th>Απολέπιση</th> <th></th> <th>Αιματώματα</th> <th></th> <th>Κοιλιά</th>
    </tr>
    <tr>
      <td>Λεία & Υγρή <input class="form-control" type="radio" name="stat_sarkas" value="Λεία & Υγρή" '.($row['stat_sarkas']=='Λεία & Υγρή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Ιριδίζον <input class="form-control" type="radio" name="stat_xrwma" value="Ιριδίζον" '.($row['stat_xrwma']=='Ιριδίζον' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Ελαφρή <input class="form-control" type="radio" name="stat_apolepish" value="Ελαφρή" '.($row['stat_apolepish']=='Ελαφρή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Κεφαλή <input class="form-control" type="radio" name="stat_aimatwmata" value="Κεφαλή" '.($row['stat_aimatwmata']=='Κεφαλή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Κυλινδρική <input class="form-control" type="radio" name="stat_koilia" value="Κυλινδρική" '.($row['stat_koilia']=='Κυλινδρική' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κέρινη <input class="form-control" type="radio" name="stat_sarkas" value="Κέρινη" '.($row['stat_sarkas']=='Κέρινη' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Ζωηρό <input class="form-control" type="radio" name="stat_xrwma" value="Ζωηρό" '.($row['stat_xrwma']=='Ζωηρό' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Μεσαία <input class="form-control" type="radio" name="stat_apolepish" value="Μεσαία" '.($row['stat_apolepish']=='Μεσαία' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Σώμα <input class="form-control" type="radio" name="stat_aimatwmata" value="Σώμα" '.($row['stat_aimatwmata']=='Σώμα' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Διογκωμένη <input class="form-control" type="radio" name="stat_koilia" value="Διογκωμένη" '.($row['stat_koilia']=='Διογκωμένη' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Στεγνή <input class="form-control" type="radio" name="stat_sarkas" value="Στεγνή" '.($row['stat_sarkas']=='Στεγνή' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Θαμπό <input class="form-control" type="radio" name="stat_xrwma" value="Θαμπό" '.($row['stat_xrwma']=='Θαμπό' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Έντονη <input class="form-control" type="radio" name="stat_apolepish" value="Έντονη" '.($row['stat_apolepish']=='Έντονη' ? 'checked="checked"' : '').'/></td>  <td></td>
      <td>Περιοχές <input class="form-control" type="radio" name="stat_aimatwmata" value="Περιοχές" '.($row['stat_aimatwmata']=='Περιοχές' ? 'checked="checked"' : '').'/></td> <td></td>
      <td>Μαλακή <input class="form-control" type="radio" name="stat_koilia" value="Μαλακή" '.($row['stat_koilia']=='Μαλακή' ? 'checked="checked"' : '').'/></td>
    </tr>
  </table>
  </div>

    <table border="1" class="table table-striped table-bordered table-condensed  table-responsive">
    <tr>
      <th></th> <th>Τυπική</th> <th>Προβληματική</th> <th>Μη Αποδεκτή</th> <th>Διόρθωση</th>
    </tr>
    <tr>
      <td>Κουρμπάρισμα</td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Τυπική" '.($row['susk_kourmparisma']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Προβληματική" '.($row['susk_kourmparisma']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Μη Αποδεκτή" '.($row['susk_kourmparisma']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_kourmparisma" value="Διόρθωση" '.($row['susk_kourmparisma']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Φελιζόλ</td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Τυπική" '.($row['susk_felizol']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Προβληματική" '.($row['susk_felizol']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Μη Αποδεκτή" '.($row['susk_felizol']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_felizol" value="Διόρθωση" '.($row['susk_felizol']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Πάγου</td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Τυπική" '.($row['susk_pagos']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Προβληματική" '.($row['susk_pagos']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Μη Αποδεκτή" '.($row['susk_pagos']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_pagos" value="Διόρθωση" '.($row['susk_pagos']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Παλέτας</td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Τυπική" '.($row['susk_paleta']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Προβληματική" '.($row['susk_paleta']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Μη Αποδεκτή" '.($row['susk_paleta']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_paleta" value="Διόρθωση" '.($row['susk_paleta']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
    <tr>
      <td>Κατάσταση Σήμανσης</td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Τυπική" '.($row['susk_shmansh']=='Τυπική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Προβληματική" '.($row['susk_shmansh']=='Προβληματική' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Μη Αποδεκτή" '.($row['susk_shmansh']=='Μη Αποδεκτή' ? 'checked="checked"' : '').'/></td>
      <td><input class="form-control" type="radio" name="susk_shmansh" value="Διόρθωση" '.($row['susk_shmansh']=='Διόρθωση' ? 'checked="checked"' : '').'/></td>
    </tr>
  </table>
  <br />
          <div id="filelist">Your browser doesn\'t have Flash, Silverlight or HTML5 support.</div>

          <div id="upcontainer">
            <a id="pickfiles" href="javascript:;" class="btn btn-default">Select files</a>
            <a id="uploadfiles" href="javascript:;" class="btn btn-default">Upload files</a>
          </div>

  <br />
  <div>
  <p><b>ΠΑΡΑΤΗΡΗΣΕΙΣ: Οι θερμογράφοι να είναι σε ετοιμότητα 24ωρης εγγραφής!!! <br />Σύντομη Περιγραφή του Δείγματος</b></p>
  <textarea name="comment" style="height:200px;width:400px;">'.$row['parathrhseis'].'</textarea>
  <br />
  <!-- <input class="form-control" type="submit" name="submit" value="Καταχώρηση" style="height:100px;width:200px;" /> -->
    <input class="btn btn-default" type="submit" name="submit" value="Καταχώρηση" style="height:70px;width:200px;" id="form-submit" />
  <input type="hidden" name="picture" id="picinp" value=\''.$row['picture'].'\' /><input type="hidden" id="freskothta" name="freskothta" value="" />
  </div>
</div>

</form></div>';
$pics = json_decode($row['picture']);
  if(sizeof($pics)>0){
    echo "<div class='panel panel-default'>
    				<div class='panel-heading'>
    					Φωτογραφίες
    				</div>
    				<div class='panel-body'>";
     $ii=1;
  echo "<div id='pics'><div class'row'>";
  foreach($pics as $pic){
  try{
    $resize = new ResizeImage('uploads/images/'.$pic);
    $resize->resizeTo(300, 300, 'maxHeight');
    $resize->saveImage('uploads/images/temp/'.$pic);
    echo "<div class='col-sm-".(12/sizeof($pics))."'><img height=\"300\" onclick=\"zoom('".$pic."');\" src=\"uploads/images/temp/".$pic."\" /></div>";
  } catch (Exception $e) {
    // echo 'Caught exception: ',  $e->getMessage(), "\n";
  }

    if($ii%4==0){
      echo "</div><div class='row'>";
    }
    $ii++;
  }
  echo "</div></div></div>";
  }

  echo "</div>";
}
?>
