<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<?php
include('header.php');
date_default_timezone_set("Europe/Athens");
?>
<script src="js/chart.min.js"></script>
<script>
$(document).ready(function(){
  getPack();
  drawPie();
  $('#from, #to, #pack, #megethos').on('change', function(){
    drawPie();
  });
});

function getPack(){
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {type:'pack'},
    success: function(r){
	     data = JSON.parse(r);
       data.forEach(function(item){
				 $("#pack").append("<option value='"+item[0]+"'>"+item[0]+"</option>");
			 });
     }
   });
}

function drawPie(){
  $('#chart').remove(); // this is my <canvas> element
  $('#chart-container').append('<canvas id="chart"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {from:$('#from').val(), to:$('#to').val(), kwd_sus:$('#pack').val(), type:'e'},
    success: function(r){
	     data = JSON.parse(r);
       console.log(data);
     }
   });
   //(x*100)/y
  var ctx = document.getElementById("chart");
  var myChart = new Chart(ctx, {
      type: 'pie',
      data: {
          labels: [
            "red("+((data['red']*100)/data['total']).toFixed(0)+"%)", 
            "yellow("+((data['yellow']*100)/data['total']).toFixed(0)+"%)", 
            "orange("+((data['orange']*100)/data['total']).toFixed(0)+"%)", 
            "green("+((data['green']*100)/data['total']).toFixed(0)+"%)", 
            "blue("+((data['blue']*100)/data['total']).toFixed(0)+"%)", 
            "blueblack("+((data['blueblack']*100)/data['total']).toFixed(0)+"%)"],
          datasets: [
            {
              data: [data['red'], data['yellow'], data['orange'],data['green'], data['blue'], data['blueblack']],
              backgroundColor: ["red", "yellow", "orange", "green", "blue", "darkblue"],
              stack: 1
            }

          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:false
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
  });

}

</script>

<div class="row">
  <div class="col-sm-2 col-sm-offset-3">
    Από: <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2">
    Έως: <input type="date" id="to" class="form-control" />
  </div>
  <div class="col-sm-2">
    Συσκευαστήριο:
    <select id="pack" class="form-control">
      <option value="" selected>Όλα</option>
    </select>
  </div>
</div>
<br />
<div class="row">
  <div id="chart-container">
    <canvas id="chart"></canvas>
  </div>
</div>