<?php
require 'header.php';
?>

<script src="js/chart.min.js"></script>
<script>
function draw(){
  $('#mybar').remove(); // this is my <canvas> element
  $('#bar-container').append('<canvas id="mybar"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'classes/chart.php',
    async: false,
    data: {from : $('#from').val(), to : $('#to').val(), type:$('#filter').val(),monada: $('#monada').val(),susk: $('#susk').val()},
    success: function(r){
	     data = JSON.parse(r);
         console.log(data);
     }
   });
  var ctx = document.getElementById("mybar");
  var myChart = new Chart(ctx, {
      type: 'bar',
      data: {
          labels: data["Headers"],
          datasets: [
            {
              label: `(${data['total']})`,
              data: data["statSum"],
              backgroundColor: ["#3D4756","#007CC4","#7293BC","#A1ACBD","#DF9F1F","#2F6762","#B0CCC8","#D0474A","#008B37","#D2A359","#4C75C7"],
              stack: 1
            }
            // {
            //   label:"Συνολικά",
            //   data: [377730,377730,377730,377730,377730,377730],
            //   backgroundColor: "lightGray",
            //   stack: 2
            // }
          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:true,
                      fontStyle: 'bold'
                  }
              }],
              xAxes: [{
                stacked: true,
                maxBarThickness: 60,
                minBarThickness: 40
            }]
          }
      }
  });
}


$('document').ready(function(){
  draw();
  // drawPie();
  $('#from, #to, #monada, #filter, #susk').on('change', function(){
    draw();
  })
})

</script>
<div class="row">
  <div class="col-sm-2 col-sm-offset-1">
  <label>Συσκευαστήριο:</label>
    <select id="susk" class="form-control">
        <option value="">Όλα</option>
        <?php
$res = mysqli_query($dbC, "SELECT `text` FROM packing");
while ($monada = mysqli_fetch_assoc($res)) {
    echo "<option value='{$monada['text']}'>{$monada['text']}</option>";
}
?>
    </select>
  </div>
  <div class="col-sm-2">
  <label>Μονάδα Πάχυνσης:</label>
    <select id="monada" class="form-control">
        <option value="">Όλα</option>
        <?php
$res = mysqli_query($dbC, "SELECT `text` FROM monada");
while ($monada = mysqli_fetch_assoc($res)) {
    echo "<option value='{$monada['text']}'>{$monada['text']}</option>";
}
?>
    </select>
  </div>
  <div class="col-sm-2">
    <label>Από:</label> <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2">
    <label>Έως:</label> <input type="date" id="to" class="form-control" />
  </div>
  <div class="col-sm-2">
    <label>Φίλτρο:</label>
    <select id="filter" class="form-control">
            <optgroup>
                <option value="kefalh">Κεφαλή</option>
                <option value="koilia">Κοιλιά</option>
                <option value="swma">Σώμα</option>
                <option value="bragxia">Βράγχια</option>
                <option value="matia">Μάτια</option>
                <option value="dusmorfies">Δυσμορφίες</option>
                <option value="alloiwseis">Αλλοιώσεις</option>
                <option value="parasita">Παράσιτα</option>
            </optgroup>

            <optgroup>
                <option value="katast_dermatos">Κατάσταση Δέρματος</option>
                <option value="katast_ofthalmou">Κατάσταση Οφθαλμού</option>
                <option value="katast_bragxiwn">Κατάσταση Βραγχίων</option>
            </optgroup>

            <optgroup>
                <option value="stat_sarkas">Κατάσταση Σάρκας</option>
                <option value="stat_xrwma">Κατάσταση Χρώματος</option>
                <option value="stat_apolepish">Κατάσταση Απολέπισης</option>
                <option value="stat_aimatwmata">Κατάσταση - Αιματώματα</option>
                <option value="stat_koilia">Κατάσταση Κοιλιάς</option>
            </optgroup>

            <optgroup>
                <option value="susk_felizol">Συσκευασία - Φελιζόλ</option>
                <option value="susk_pagos">Συσκευασία - Πάγος</option>
                <option value="susk_paleta">Συσκευασία - Παλέτα</option>
                <option value="susk_shmansh">Συσκευασία - Σήμανση</option>
            </optgroup>

            <optgroup>
                <option value="freskothta">Φρεσκότητα</option>
            </optgroup>

    </select>

  </div>
</div>
<div class="row">
  <div id="bar-container" class="col-md-12">
    <canvas id="mybar"></canvas>
  </div>
</div>

<!-- <div class="row">
  <div id="pie-container" class="col-sm-8 col-sm-offset-2" style="width:40vw;height:30vh;">
    <canvas id="mypie"></canvas>
  </div>
</div> -->
<?php require 'footer.php';?>