<?php
require('header.php');
?>

<script src="js/chart.min.js"></script>
<script>
function draw(from='', to=''){
  $('#mybar').remove(); // this is my <canvas> element
  $('#bar-container').append('<canvas id="mybar"><canvas>');
  var data;
  $.ajax({
    type: "POST",
    url: 'chartdat.php',
    async: false,
    data: {from : from, to : to, type:'all'},
    success: function(r){
	     data = JSON.parse(r);
      //  console.log(data);
     }
   });

  var ctx = document.getElementById("mybar");
  var myChart = new Chart(ctx, {
      type: 'bar',
      data: {
          labels: data["comp"],
          datasets: [
            {
              label: "Αποδεκτές",
              data: data["app"],
              backgroundColor: "#3FBF3F",
              stack: 1
            },
            {
              label: "Μή Αποδεκτές",
              data: data["dec"],
              backgroundColor: "#BF3F3F",
              stack: 1
            }
          ]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:true
                  }
              }],
              xAxes: [{
                stacked: true
            }]
          }
      }
  });
}

// function drawPie(from='', to=''){
//   $('#mypie').remove(); // this is my <canvas> element
//   $('#pie-container').append('<canvas id="mypie"><canvas>');
//   var data;
//   $.ajax({
//     type: "POST",
//     url: 'chartdat.php',
//     async: false,
//     data: {from : from, to : to},
//     success: function(r){
// 	     data = JSON.parse(r);
//        // console.log(data);
//      }
//    });
//
//   var ctx = document.getElementById("mypie");
//   var myChart = new Chart(ctx, {
//       type: 'pie',
//       data: {
//           labels: data["comp"],
//           datasets: [
//             {
//               label: "Αποδεκτές",
//               data: data["app"],
//               backgroundColor: "#3FBF3F",
//               stack: 1
//             }
//           ]
//       },
//       options: {
//           scales: {
//               yAxes: [{
//                   ticks: {
//                       beginAtZero:true
//                   }
//               }],
//               xAxes: [{
//                 stacked: true
//             }]
//           }
//       }
//   });
// }

$('document').ready(function(){
  draw();
  // drawPie();
  $('#from, #to').on('change', function(){
    draw($('#from').val(), $('#to').val());
  })
})

</script>
<div class="row">
  <div class="col-sm-4"></div>
  <div class="col-sm-2">
    Από: <input type="date" id="from" class="form-control" />
  </div>
  <div class="col-sm-2">
    Έως: <input type="date" id="to" class="form-control" />
  </div>
</div>
<div class="row">
  <div id="bar-container" class="col-md-12">
    <canvas id="mybar"></canvas>
  </div>
</div>

<!-- <div class="row">
  <div id="pie-container" class="col-sm-8 col-sm-offset-2" style="width:40vw;height:30vh;">
    <canvas id="mypie"></canvas>
  </div>
</div> -->
<?php require('footer.php'); ?>